/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.event;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.time.LocalDateTime;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class BuildingPermissionState
implements IDialogState {
    private LocalDateTime date;
    private String location;
    private IPlayer player;
    private String className;
    private String methodName;

    public BuildingPermissionState(LocalDateTime date, String location, IPlayer player) {
        this.date = date;
        this.location = location;
        this.player = player;
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        this.methodName = creatingStackFrame.getMethodName();
        this.className = creatingStackFrame.getClassName();
    }

    public String getDialogBeanName() {
        return "buildingPermissionDialog";
    }

    public static BuildingPermissionStateBuilder builder() {
        return new BuildingPermissionStateBuilder();
    }

    public LocalDateTime getDate() {
        return this.date;
    }

    public String getLocation() {
        return this.location;
    }

    public IPlayer getPlayer() {
        return this.player;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public static class BuildingPermissionStateBuilder {
        private LocalDateTime date;
        private String location;
        private IPlayer player;

        BuildingPermissionStateBuilder() {
        }

        public BuildingPermissionStateBuilder date(LocalDateTime date) {
            this.date = date;
            return this;
        }

        public BuildingPermissionStateBuilder location(String location) {
            this.location = location;
            return this;
        }

        public BuildingPermissionStateBuilder player(IPlayer player) {
            this.player = player;
            return this;
        }

        public BuildingPermissionState build() {
            return new BuildingPermissionState(this.date, this.location, this.player);
        }

        public String toString() {
            return "BuildingPermissionState.BuildingPermissionStateBuilder(date=" + this.date + ", location=" + this.location + ", player=" + this.player + ")";
        }
    }
}

