/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.event;

import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;

@ClassCategory(value={EClassCategory.EVENT_OBJECT})
public final class ConvoyEvent
implements IEventMetaDataProvider {
    private final IConvoy convoy;
    private final IShip ship;
    private final boolean joining;
    private final String className;
    private final String methodName;

    public ConvoyEvent(IConvoy convoy, IShip ship, boolean joining) {
        this.convoy = convoy;
        this.ship = ship;
        this.joining = joining;
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        this.methodName = creatingStackFrame.getMethodName();
        this.className = creatingStackFrame.getClassName();
    }

    public IConvoy getConvoy() {
        return this.convoy;
    }

    public IShip getShip() {
        return this.ship;
    }

    public boolean isJoining() {
        return this.joining;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvoyEvent)) {
            return false;
        }
        ConvoyEvent other = (ConvoyEvent)o;
        IConvoy this$convoy = this.getConvoy();
        IConvoy other$convoy = other.getConvoy();
        if (this$convoy == null ? other$convoy != null : !this$convoy.equals(other$convoy)) {
            return false;
        }
        IShip this$ship = this.getShip();
        IShip other$ship = other.getShip();
        if (this$ship == null ? other$ship != null : !this$ship.equals(other$ship)) {
            return false;
        }
        if (this.isJoining() != other.isJoining()) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        return !(this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IConvoy $convoy = this.getConvoy();
        result = result * 59 + ($convoy == null ? 43 : $convoy.hashCode());
        IShip $ship = this.getShip();
        result = result * 59 + ($ship == null ? 43 : $ship.hashCode());
        result = result * 59 + (this.isJoining() ? 79 : 97);
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
        return result;
    }

    public String toString() {
        return "ConvoyEvent(convoy=" + this.getConvoy() + ", ship=" + this.getShip() + ", joining=" + this.isJoining() + ", className=" + this.getClassName() + ", methodName=" + this.getMethodName() + ")";
    }
}

