/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.event;

import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.time.LocalDateTime;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class DowryState
implements IDialogState {
    private LocalDateTime date;
    private String location;
    private IShip ship;
    private String className;
    private String methodName;

    public DowryState(LocalDateTime date, String location, IShip ship) {
        this.date = date;
        this.location = location;
        this.ship = ship;
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        this.methodName = creatingStackFrame.getMethodName();
        this.className = creatingStackFrame.getClassName();
    }

    public String getDialogBeanName() {
        return "dowryDialog";
    }

    public static DowryStateBuilder builder() {
        return new DowryStateBuilder();
    }

    public LocalDateTime getDate() {
        return this.date;
    }

    public String getLocation() {
        return this.location;
    }

    public IShip getShip() {
        return this.ship;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public static class DowryStateBuilder {
        private LocalDateTime date;
        private String location;
        private IShip ship;

        DowryStateBuilder() {
        }

        public DowryStateBuilder date(LocalDateTime date) {
            this.date = date;
            return this;
        }

        public DowryStateBuilder location(String location) {
            this.location = location;
            return this;
        }

        public DowryStateBuilder ship(IShip ship) {
            this.ship = ship;
            return this;
        }

        public DowryState build() {
            return new DowryState(this.date, this.location, this.ship);
        }

        public String toString() {
            return "DowryState.DowryStateBuilder(date=" + this.date + ", location=" + this.location + ", ship=" + this.ship + ")";
        }
    }
}

