/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.event;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.time.LocalDateTime;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class MarriageFeastRequestState
implements IDialogState {
    private LocalDateTime date;
    private ICity location;
    private boolean genderMale;
    private String toLastName;
    private String className;
    private String methodName;
    private boolean accepted = false;

    public MarriageFeastRequestState(LocalDateTime date, ICity location, boolean genderMale, String toLastName, boolean accepted) {
        this.date = date;
        this.location = location;
        this.genderMale = genderMale;
        this.toLastName = toLastName;
        this.accepted = accepted;
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        this.methodName = creatingStackFrame.getMethodName();
        this.className = creatingStackFrame.getClassName();
    }

    public String getDialogBeanName() {
        return "marriageFeastRequestDialog";
    }

    public String toString() {
        return "MarriageFeastRequestState{date=" + this.date + ", location='" + this.location.getName() + "', genderMale=" + this.genderMale + ", toLastName='" + this.toLastName + "'}";
    }

    public static MarriageFeastRequestStateBuilder builder() {
        return new MarriageFeastRequestStateBuilder();
    }

    public LocalDateTime getDate() {
        return this.date;
    }

    public ICity getLocation() {
        return this.location;
    }

    public boolean isGenderMale() {
        return this.genderMale;
    }

    public String getToLastName() {
        return this.toLastName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    public static class MarriageFeastRequestStateBuilder {
        private LocalDateTime date;
        private ICity location;
        private boolean genderMale;
        private String toLastName;
        private boolean accepted;

        MarriageFeastRequestStateBuilder() {
        }

        public MarriageFeastRequestStateBuilder date(LocalDateTime date) {
            this.date = date;
            return this;
        }

        public MarriageFeastRequestStateBuilder location(ICity location) {
            this.location = location;
            return this;
        }

        public MarriageFeastRequestStateBuilder genderMale(boolean genderMale) {
            this.genderMale = genderMale;
            return this;
        }

        public MarriageFeastRequestStateBuilder toLastName(String toLastName) {
            this.toLastName = toLastName;
            return this;
        }

        public MarriageFeastRequestStateBuilder accepted(boolean accepted) {
            this.accepted = accepted;
            return this;
        }

        public MarriageFeastRequestState build() {
            return new MarriageFeastRequestState(this.date, this.location, this.genderMale, this.toLastName, this.accepted);
        }

        public String toString() {
            return "MarriageFeastRequestState.MarriageFeastRequestStateBuilder(date=" + this.date + ", location=" + this.location + ", genderMale=" + this.genderMale + ", toLastName=" + this.toLastName + ", accepted=" + this.accepted + ")";
        }
    }
}

