/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.event;

import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.time.LocalDateTime;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class SpouseDeathState
implements IDialogState {
    private LocalDateTime date;
    private String location;
    private String className;
    private String methodName;

    public SpouseDeathState(LocalDateTime date, String location) {
        this.date = date;
        this.location = location;
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        this.methodName = creatingStackFrame.getMethodName();
        this.className = creatingStackFrame.getClassName();
    }

    public String getDialogBeanName() {
        return "spouseDeathDialog";
    }

    public static SpouseDeathStateBuilder builder() {
        return new SpouseDeathStateBuilder();
    }

    public LocalDateTime getDate() {
        return this.date;
    }

    public String getLocation() {
        return this.location;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public static class SpouseDeathStateBuilder {
        private LocalDateTime date;
        private String location;

        SpouseDeathStateBuilder() {
        }

        public SpouseDeathStateBuilder date(LocalDateTime date) {
            this.date = date;
            return this;
        }

        public SpouseDeathStateBuilder location(String location) {
            this.location = location;
            return this;
        }

        public SpouseDeathState build() {
            return new SpouseDeathState(this.date, this.location);
        }

        public String toString() {
            return "SpouseDeathState.SpouseDeathStateBuilder(date=" + this.date + ", location=" + this.location + ")";
        }
    }
}

