/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.factory;

import ch.sahits.game.graphic.image.IMapSegmentImageCreator;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.AIStrategyLoader;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.BuildingFactory;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.CityFactory;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.PlayerInteractionFactory;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.ShipFactory;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.StateFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.StrategyHolderService;
import ch.sahits.game.openpatrician.data.xmlmodel.map.Map;
import ch.sahits.game.openpatrician.data.xmlmodel.map.Offset;
import ch.sahits.game.openpatrician.model.AIPlayerList;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.Difficulty;
import ch.sahits.game.openpatrician.model.EGameSpeed;
import ch.sahits.game.openpatrician.model.EObjective;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IGame;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.TradingOfficeList;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.city.Shipyards;
import ch.sahits.game.openpatrician.model.city.impl.CityRegistry;
import ch.sahits.game.openpatrician.model.city.impl.CityState;
import ch.sahits.game.openpatrician.model.city.impl.Contributions;
import ch.sahits.game.openpatrician.model.city.impl.ECityLabelAlignment;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.impl.AIPlayer;
import ch.sahits.game.openpatrician.model.impl.Company;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.map.ITradeRoute;
import ch.sahits.game.openpatrician.model.map.ITradeRouteStop;
import ch.sahits.game.openpatrician.model.map.impl.FutureTowns;
import ch.sahits.game.openpatrician.model.map.impl.GameMap;
import ch.sahits.game.openpatrician.model.map.impl.LandBridge;
import ch.sahits.game.openpatrician.model.map.impl.TradeRoute;
import ch.sahits.game.openpatrician.model.map.impl.TradeRouteStop;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.IReputation;
import ch.sahits.game.openpatrician.model.personal.impl.PersonalData;
import ch.sahits.game.openpatrician.model.personal.impl.Reputation;
import ch.sahits.game.openpatrician.model.player.AIPlayerContext;
import ch.sahits.game.openpatrician.model.player.BaseStrategyType;
import ch.sahits.game.openpatrician.model.player.EPlayerColor;
import ch.sahits.game.openpatrician.model.player.IAIBuyWeaponStrategyType;
import ch.sahits.game.openpatrician.model.player.IAICaptainHireStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIConstructionSelectionStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIEventDecisionStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIGuildJoinStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIHireSailorsStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIHireTradeManagerStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIShipRepairStrategyType;
import ch.sahits.game.openpatrician.model.player.IAIShipUpgradeStrategyType;
import ch.sahits.game.openpatrician.model.player.IAITakeLoanStrategyType;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategy;
import ch.sahits.game.openpatrician.model.player.IAITradeStrategyType;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.sea.ILocationTracker;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.ICrayer;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.weapon.ArmoryRegistry;
import ch.sahits.game.openpatrician.model.weapon.IArmory;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.utilities.service.RandomNameLoader;
import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class GameFactory {
    private static final Logger log = LoggerFactory.getLogger(GameFactory.class);
    @Autowired
    private Random rnd;
    @Autowired
    private CityFactory cityFactory;
    @Autowired
    private Date date;
    @Autowired
    private BuildingFactory buildingFactory;
    private IGame game;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private CityRegistry cityRegistry;
    @Autowired
    private PlayerList players;
    @Autowired
    private AIPlayerList aiPlayers;
    @Autowired
    @Qualifier(value="shipNameLoader")
    private RandomNameLoader shipNameLoader;
    @Autowired
    private ShipFactory shipFactory;
    @Autowired
    private IMapSegmentImageCreator mapLoader;
    @Autowired
    protected Interner<Point2D> pointInterner;
    @Autowired
    private PlayerInteractionFactory interactionFactory;
    @Autowired
    private TradingOfficeList offices;
    @Autowired
    private AIStrategyLoader strategyLoader;
    @Autowired
    private StrategyHolderService strategyHolderService;
    @ListType(value=IAIShipRepairStrategyType.class)
    private List<IAIShipRepairStrategyType> repairTypes = null;
    @ListType(value=IAITakeLoanStrategyType.class)
    private List<IAITakeLoanStrategyType> takeLoanStrategies = null;
    @ListType(value=IAIConstructionSelectionStrategyType.class)
    private List<IAIConstructionSelectionStrategyType> constructionStrategies = null;
    @ListType(value=IAICaptainHireStrategyType.class)
    private List<IAICaptainHireStrategyType> hireCaptainStrategies = null;
    @ListType(value=IAIGuildJoinStrategyType.class)
    private List<IAIGuildJoinStrategyType> guildJoinStrategies;
    @ListType(value=IAIEventDecisionStrategyType.class)
    private List<IAIEventDecisionStrategyType> eventDecisionStrategies;
    @ListType(value=IAIHireTradeManagerStrategyType.class)
    private static List<IAIHireTradeManagerStrategyType> hireTradeManagerStrategies;
    @ListType(value=IAIBuyWeaponStrategyType.class)
    private static List<IAIBuyWeaponStrategyType> weaponBuyStrategies;
    @ListType(value=IAIHireSailorsStrategyType.class)
    private static List<IAIHireSailorsStrategyType> hireSailorStrategies;
    @ListType(value=IAIShipUpgradeStrategyType.class)
    private static List<IAIShipUpgradeStrategyType> shipUpgradeStrategies;
    private StateFactory stateFactory;
    private ILocationTracker locationTracker;

    public IHumanPlayer createPlayer(String name, String lastName, ICity homeTown, boolean male, int cash, EPlayerColor color) {
        int age = this.rnd.nextInt(10) + 17;
        PersonalData pd = new PersonalData(name, lastName, male, homeTown, this.computeRandomBirthDate(age));
        Company company = this.createCompany(homeTown, cash);
        IHumanPlayer player = (IHumanPlayer)this.context.getBean("humanPlayer", new Object[]{homeTown, pd, ESocialRank.CHANDLER, company, color});
        company.setOwner((IPlayer)player);
        ITradingOffice office = this.buildingFactory.createTradingOffice((IPlayer)player, homeTown, 0);
        this.offices.add(office);
        this.initPlayerInCities((IPlayer)player);
        this.players.add((IPlayer)player);
        return player;
    }

    public IAIPlayer createAIPlayer(ICity homeTown, long cash) {
        int age = this.rnd.nextInt(15) + 17;
        Company company = this.createCompany(homeTown, cash);
        AIPlayer player = (AIPlayer)this.context.getBean("aiPlayer", new Object[]{homeTown, this.computeRandomBirthDate(age), company});
        company.setOwner((IPlayer)player);
        ITradingOffice office = this.buildingFactory.createTradingOffice((IPlayer)player, homeTown, 0);
        this.offices.add(office);
        this.initPlayerInCities((IPlayer)player);
        ICrayer ship = this.shipFactory.createCrayer(this.shipNameLoader.getRandomName(), EShipUpgrade.LEVEL1, 350);
        ship.setOwner((IShipOwner)player);
        player.addShip((IShip)ship);
        player.addSelectableVessel((INavigableVessel)ship);
        ship.setLocation(homeTown.getCoordinates());
        if (this.locationTracker == null) {
            this.locationTracker = (ILocationTracker)this.context.getBean(ILocationTracker.class);
        }
        log.debug("Created {} @ {} ({})for {} {}", new Object[]{ship.getName(), ship.hashCode(), ship.getUuid(), player.getName(), player.getLastName()});
        this.locationTracker.add((INavigableVessel)ship);
        if (this.repairTypes == null) {
            this.repairTypes = this.strategyLoader.getRepairStrategies();
        }
        if (this.takeLoanStrategies == null) {
            this.takeLoanStrategies = this.strategyLoader.getTakeLoanStrategies();
        }
        if (this.constructionStrategies == null) {
            this.constructionStrategies = this.strategyLoader.getConstructionSelectionStrategies();
        }
        if (this.hireCaptainStrategies == null) {
            this.hireCaptainStrategies = this.strategyLoader.getCaptainHireStrategies();
        }
        if (this.guildJoinStrategies == null) {
            this.guildJoinStrategies = this.strategyLoader.getGuildJoinStrategies();
        }
        if (this.eventDecisionStrategies == null) {
            this.eventDecisionStrategies = this.strategyLoader.getEventDecisionStrategies();
        }
        if (hireTradeManagerStrategies == null) {
            hireTradeManagerStrategies = this.strategyLoader.getHireTradeManagerStrategies();
        }
        if (weaponBuyStrategies == null) {
            weaponBuyStrategies = this.strategyLoader.getWeaponBuyStrategies();
        }
        if (hireSailorStrategies == null) {
            hireSailorStrategies = this.strategyLoader.getHireSailorStrategies();
        }
        if (shipUpgradeStrategies == null) {
            shipUpgradeStrategies = this.strategyLoader.getShipUpgradeStrategies();
        }
        List tradeStrategies = this.strategyHolderService.getTradeStrategies().stream().filter(arg_0 -> GameFactory.lambda$createAIPlayer$0(player, (IShip)ship, arg_0)).collect(Collectors.toList());
        player.setTradeStrategyType((INavigableVessel)ship, (IAITradeStrategyType)tradeStrategies.get(this.rnd.nextInt(tradeStrategies.size())));
        player.setShipRepairStrategyType(this.repairTypes.get(this.rnd.nextInt(this.repairTypes.size())));
        player.setTakeLoanStrategyType(this.takeLoanStrategies.get(this.rnd.nextInt(this.takeLoanStrategies.size())));
        player.setConstructionSelectionType(this.constructionStrategies.get(this.rnd.nextInt(this.constructionStrategies.size())));
        player.setCaptainHireStrategyType(this.hireCaptainStrategies.get(this.rnd.nextInt(this.hireCaptainStrategies.size())));
        player.setEventDecitionStrategyType(this.eventDecisionStrategies.get(this.rnd.nextInt(this.eventDecisionStrategies.size())));
        AIPlayerContext context = player.getPlayerContext();
        context.add((BaseStrategyType)hireTradeManagerStrategies.get(this.rnd.nextInt(hireTradeManagerStrategies.size())));
        context.add((BaseStrategyType)this.guildJoinStrategies.get(this.rnd.nextInt(this.guildJoinStrategies.size())));
        context.add((BaseStrategyType)weaponBuyStrategies.get(this.rnd.nextInt(weaponBuyStrategies.size())));
        context.add((BaseStrategyType)hireSailorStrategies.get(this.rnd.nextInt(hireSailorStrategies.size())));
        context.add((BaseStrategyType)shipUpgradeStrategies.get(this.rnd.nextInt(shipUpgradeStrategies.size())));
        this.players.add((IPlayer)player);
        this.aiPlayers.add((IAIPlayer)player);
        return player;
    }

    private void initPlayerInCities(IPlayer player) {
        for (ICity city : this.cityFactory.getCities()) {
            Reputation rep = this.interactionFactory.createReputation(city, player);
            Contributions contributions = this.interactionFactory.createContribution();
            city.moveIn(player, (IReputation)rep, contributions);
        }
    }

    public IMap createMap(String mapName) {
        this.cityFactory.initializeCityCache(mapName);
        Map m = this.cityFactory.getMap();
        GameMap map = (GameMap)this.context.getBean(IMap.class);
        Dimension2D dim = new Dimension2D((double)m.getDimension().getX().intValue(), (double)m.getDimension().getY().intValue());
        this.mapLoader.loadMap(m.getImageName());
        m.getTradeRoutes();
        map.setup(this.cityFactory.getCities(), dim, m.getImageName(), m.getBwImageName(), m.getPixelsPerKilometer().doubleValue());
        for (Map.TradeRoutes.Route route : m.getTradeRoutes().getRoute()) {
            TradeRoute tradeRoute = (TradeRoute)this.context.getBean(TradeRoute.class);
            for (Map.TradeRoutes.Route.Place place : route.getPlace()) {
                TradeRouteStop tradeStop = (TradeRouteStop)this.context.getBean(TradeRouteStop.class);
                String cityName = place.getName();
                ICity city = this.cityFactory.createCityByName(cityName);
                Preconditions.checkNotNull((Object)city, (Object)("Failed to finde city for name " + cityName));
                List wareNames = place.getWare();
                tradeStop.setTradeStop(city);
                HashSet<EWare> waresToBuy = new HashSet<EWare>();
                for (String wareName : wareNames) {
                    EWare ware = EWare.valueOf((String)wareName);
                    waresToBuy.add(ware);
                }
                tradeStop.setWaresToBuy(waresToBuy);
                tradeRoute.addTradeStop((ITradeRouteStop)tradeStop);
            }
            map.addTradeRoute((ITradeRoute)tradeRoute);
        }
        List newTowns = m.getNewlocations().getNewtown();
        List futures = map.getFutureTowns();
        for (Map.Newlocations.Newtown newTown : newTowns) {
            Offset offset = newTown.getOffset();
            ECityLabelAlignment alignment = ECityLabelAlignment.LEFT;
            if (offset.getAlignment() != null) {
                alignment = ECityLabelAlignment.valueOf((String)offset.getAlignment().value());
            }
            futures.add(new FutureTowns(newTown.getName(), (Point2D)this.pointInterner.intern((Object)new Point2D((double)newTown.getLocation().getX(), (double)newTown.getLocation().getY())), newTown.isRiver(), new Point2D((double)offset.getX(), (double)offset.getY()), alignment));
        }
        List bridges = m.getLandbridges().getLandbridge();
        List landbridges = map.getLandbridges();
        for (Map.Landbridges.Landbridge bridge : bridges) {
            ICity from = map.findCity(bridge.getFrom());
            ICity to = map.findCity(bridge.getTo());
            if (from == null) {
                log.warn("The from location for the land bridge could not be found: " + bridge.getFrom());
                continue;
            }
            if (to == null) {
                log.warn("The to location for the land bridge could not be found: " + bridge.getTo());
                continue;
            }
            landbridges.add(new LandBridge(from, to));
        }
        this.context.getBean(StartNewGameBean.class);
        return map;
    }

    public IGame createGame(EObjective objective, Difficulty difficulty, EGameSpeed speed, boolean singleplayer) {
        if (this.game == null) {
            this.game = (IGame)this.context.getBean("game", new Object[]{objective, difficulty, speed, singleplayer});
        }
        return this.game;
    }

    public IGame getGame() {
        return this.game;
    }

    private LocalDateTime computeRandomBirthDate(int age) {
        int day;
        int year = this.date.getStartYear() - age;
        int month = this.rnd.nextInt(12) + 1;
        switch (month) {
            case 2: {
                day = this.rnd.nextInt(28) + 1;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                day = this.rnd.nextInt(30) + 1;
                break;
            }
            default: {
                day = this.rnd.nextInt(31) + 1;
            }
        }
        return LocalDateTime.of(year, month, day, 0, 0);
    }

    public CityState getCityState(ICity city) {
        List cityStates = this.cityRegistry.getCityStates();
        if (cityStates.contains(city)) {
            return (CityState)cityStates.get(cityStates.indexOf(city));
        }
        return this.initCityPropertyState(city);
    }

    private CityState initCityPropertyState(ICity city) {
        if (this.stateFactory == null) {
            this.stateFactory = (StateFactory)this.context.getBean(StateFactory.class);
        }
        Shipyards shipyards = (Shipyards)this.context.getBean(Shipyards.class);
        IShipyard shipyard = this.stateFactory.createShipYard(city);
        shipyards.add(shipyard, city);
        ArmoryRegistry armories = (ArmoryRegistry)this.context.getBean(ArmoryRegistry.class);
        IArmory armory = this.stateFactory.createArmory(city);
        armories.add(city, armory);
        TavernState tavernState = this.stateFactory.createTavernState(city);
        CityState state = (CityState)this.context.getBean("cityState", new Object[]{city, shipyard, tavernState});
        this.cityRegistry.add(state);
        return state;
    }

    private Company createCompany(ICity homeTown, long cash) {
        return (Company)this.context.getBean("company", new Object[]{homeTown, cash, this.rnd.nextLong()});
    }

    private static /* synthetic */ boolean lambda$createAIPlayer$0(AIPlayer player, IShip ship, IAITradeStrategyType type) {
        return ((IAITradeStrategy)type.getStrategy()).isSelectable((IAIPlayer)player, (INavigableVessel)ship);
    }
}

