/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.task;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.CelebrationSuccess;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageCelebrationState;
import ch.sahits.game.openpatrician.clientserverinterface.model.task.CelebrationTask;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class MarriageTask
extends CelebrationTask {
    @Autowired
    private Date date;
    private final ISpouseData spouseData;

    public MarriageTask(IPlayer player, ICity city, ISpouseData spouseData) {
        super(player, city);
        this.spouseData = spouseData;
    }

    @Override
    protected MarriageCelebrationState createCelebrationState(CelebrationSuccess success, int attendance) {
        return MarriageCelebrationState.builder().date(this.date.getCurrentDate()).amountGuests(attendance).location(this.getCity().getName()).success(success).spouseData(this.spouseData).build();
    }

    @Override
    public String toString() {
        return "MarriageTask{UUID=" + this.getUuid() + ", execution at " + this.getExecutionTime() + ", player=" + this.getPlayer().getUuid() + " " + this.getPlayer().getName() + " " + this.getPlayer().getLastName() + ", city=" + this.getCity().getName() + "}";
    }
}

