/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.task;

import ch.sahits.game.openpatrician.clientserverinterface.model.WaitingTradeMissionWrapper;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.OrlegShipOutfittedEvent;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.ISailorState;
import ch.sahits.game.openpatrician.model.product.ITradeMissionData;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN, EClassCategory.SERIALIZABLE_BEAN})
@Prototype
public class ReschedulableSailorHireTask
extends TimedTask {
    private final IShip ship;
    private final ISailorState sailorState;
    private final int requiredNumberOfSailors;
    private final ICity city;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private Date date;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;

    public ReschedulableSailorHireTask(IShip ship, ISailorState sailorState, int requiredNumberOfSailors, ICity city) {
        this.ship = ship;
        this.sailorState = sailorState;
        this.requiredNumberOfSailors = requiredNumberOfSailors;
        this.city = city;
    }

    public void run() {
        IAIPlayer player = (IAIPlayer)this.ship.getOwner();
        int onShip = this.ship.getNumberOfSailors();
        int nbToHire = this.requiredNumberOfSailors - onShip;
        int inTavern = this.sailorState.getNumberOfSailors();
        int hire = Math.min(inTavern, nbToHire);
        for (int i = 0; i < hire; ++i) {
            this.sailorState.hire();
        }
        this.city.getCityState().getPopUpdateStatistic().hireSailors(hire);
        this.ship.setNumberOfSailors(onShip + hire);
        if (this.requiredNumberOfSailors > this.ship.getNumberOfSailors()) {
            this.setExecutionTime(this.date.getCurrentDate().plusDays(1L));
            this.taskList.add((TimedTask)this);
        } else {
            ITradeMissionData tradeMission = player.getTradeMission((INavigableVessel)this.ship);
            if (tradeMission instanceof WaitingTradeMissionWrapper) {
                player.setTradeMission((INavigableVessel)this.ship, ((WaitingTradeMissionWrapper)tradeMission).getTradeMissionData());
            }
            this.clientServerEventBus.post((Object)new OrlegShipOutfittedEvent(this.ship, this.city));
        }
    }

    public String toString() {
        return "ReschedulableSailorHireTask{UUID=" + this.getUuid() + ", execution at " + this.getExecutionTime() + ", ship=" + this.ship.getUuid() + " " + this.ship.getName() + ", city=" + this.city.getName() + "}";
    }
}

