/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.openpatrician.clientserverinterface.model.WaitingTradeMissionWrapper;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.ConvoyCreateEvent;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.ConvoyDisolveEvent;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.ConvoyEvent;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.ShipFactory;
import ch.sahits.game.openpatrician.clientserverinterface.model.task.ReschedulableSailorHireTask;
import ch.sahits.game.openpatrician.clientserverinterface.model.task.ReschedulableWeaponBuyTask;
import ch.sahits.game.openpatrician.clientserverinterface.service.ClientServerTaskFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.OutriggerService;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.ISailorState;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.player.BuyWeapons;
import ch.sahits.game.openpatrician.model.player.IAIBuyWeaponStrategy;
import ch.sahits.game.openpatrician.model.product.ITradeMissionData;
import ch.sahits.game.openpatrician.model.ship.ConvoyList;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.eventbus.AsyncEventBus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ConvoyService {
    private static final Logger log = LoggerFactory.getLogger(ConvoyService.class);
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private ShipFactory shipFactory;
    @Autowired
    private ConvoyList convoyList;
    @Autowired
    private OutriggerService outriggerService;
    @Autowired
    private ShipService shipService;
    @Autowired
    @Qualifier(value="serverSideTaskFactory")
    private ClientServerTaskFactory taskFactory;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private Date date;

    public void join(IConvoy convoy, IShip ship) {
        convoy.addShip(ship);
        ship.parentShipProperty().setValue((Object)convoy.getOrlegShip());
        this.clientServerEventBus.post((Object)new ConvoyEvent(convoy, ship, true));
    }

    public void leave(IConvoy convoy, IShip ship) {
        convoy.removeShip(ship);
        ship.parentShipProperty().setValue(null);
        this.clientServerEventBus.post((Object)new ConvoyEvent(convoy, ship, false));
    }

    public List<IShip> dissolve(IConvoy convoy, ICity city) {
        ArrayList<IShip> ships = new ArrayList<IShip>();
        for (IShip ship : convoy.getShips()) {
            IShipOwner owner = ship.getOwner();
            convoy.removeShip(ship);
            ship.parentShipProperty().setValue(null);
            if (owner instanceof IHumanPlayer) {
                DisplayMessage msg = new DisplayMessage(EMessageCategory.TRADE, "ch.sahits.game.openpatrician.display.dialog.sea.ConvoyDialog.convoyDissolveNotification", new Object[]{convoy.getName(), ship.getName(), city.getName()});
                TargetedEvent targetMsg = new TargetedEvent((IHumanPlayer)owner, (Object)msg);
                this.clientServerEventBus.post((Object)targetMsg);
            }
            if (owner instanceof IPlayer) {
                IPlayer player = (IPlayer)owner;
                player.addSelectableVessel((INavigableVessel)ship);
            }
            ships.add(ship);
        }
        this.clientServerEventBus.post((Object)new ConvoyDisolveEvent(convoy));
        this.convoyList.remove((Object)convoy);
        return ships;
    }

    public IConvoy create(IShip orleg, boolean publicConvoy) {
        IConvoy convoy = this.shipFactory.getConvoy(orleg, publicConvoy);
        orleg.parentShipProperty().setValue((Object)orleg);
        this.clientServerEventBus.post((Object)new ConvoyCreateEvent(convoy, orleg));
        this.convoyList.add(convoy);
        IPlayer player = (IPlayer)orleg.getOwner();
        player.removeSelectableVessel((INavigableVessel)orleg);
        player.addSelectableVessel((INavigableVessel)convoy);
        return convoy;
    }

    public Optional<IShip> outfitAsOrleg(IShip ship, ICity city) {
        int actualStrength;
        if (this.shipService.isOrlegCapable(ship, city)) {
            return Optional.of(ship);
        }
        IAIPlayer player = (IAIPlayer)ship.getOwner();
        int requiredStrength = this.outriggerService.getRequiredWeaponStrength(city);
        if (requiredStrength > (actualStrength = this.shipService.calculateShipsWeaponsStrength((INavigableVessel)ship))) {
            IAIBuyWeaponStrategy weaponStrategy = (IAIBuyWeaponStrategy)player.getWeaponBuyStrategyType().getStrategy();
            int numberOfFreeSlots = weaponStrategy.getNumberOfEmptyWeaponSlots(ship);
            int numberOfFreeLargeSlots = weaponStrategy.getNumberOfEmptyLargeWeaponSlots(ship);
            int largeWeapons = (int)Math.min(Math.round((double)numberOfFreeLargeSlots / 2.0), (long)(ship.getCapacity() / 2));
            int smallWeapons = Math.min(Math.max(0, numberOfFreeSlots - largeWeapons * 2) / 2, ship.getCapacity());
            BuyWeapons buyWeapons = BuyWeapons.builder().handWeapons(ship.getMaxNumberOfSailors()).weaponOrder(Arrays.asList(EWeapon.CANNON, EWeapon.BOMBARD, EWeapon.BALLISTA_BIG, EWeapon.TREBUCHET_BIG, EWeapon.BALLISTA_SMALL, EWeapon.TREBUCHET_SMALL, EWeapon.HAND_WEAPON)).totalStrength(requiredStrength).largeWeapons(largeWeapons).smallWeapons(smallWeapons).build();
            weaponStrategy.buyWeaponsOrdered(buyWeapons, ship, player, city);
            WaitingTradeMissionWrapper tradeMission = new WaitingTradeMissionWrapper(player.getTradeMission((INavigableVessel)ship));
            player.setTradeMission((INavigableVessel)ship, (ITradeMissionData)tradeMission);
            if (requiredStrength > this.shipService.calculateShipsWeaponsStrength((INavigableVessel)ship)) {
                ReschedulableWeaponBuyTask task = this.taskFactory.getReschedulableWeaponBuyTask(ship, buyWeapons, city);
                task.setExecutionTime(this.date.getCurrentDate().plusDays(1L));
                this.taskList.add((TimedTask)task);
                return Optional.empty();
            }
            ISailorState sailorState = city.getCityState().getTavernState().getSailors();
            ReschedulableSailorHireTask hireSailors = this.taskFactory.getReschedulableSailorHireTask(ship, sailorState, ship.getMaxNumberOfSailors(), city);
            hireSailors.run();
            if (ship.getNumberOfSailors() < ship.getMaxNumberOfSailors()) {
                return Optional.empty();
            }
        } else {
            ISailorState sailorState = city.getCityState().getTavernState().getSailors();
            ReschedulableSailorHireTask hireSailors = this.taskFactory.getReschedulableSailorHireTask(ship, sailorState, ship.getMaxNumberOfSailors(), city);
            hireSailors.run();
            if (ship.getNumberOfSailors() < ship.getMaxNumberOfSailors()) {
                return Optional.empty();
            }
        }
        return Optional.of(ship);
    }
}

