/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IDateService;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class DateService
implements IDateService {
    @Autowired
    private Date date;

    public boolean isSameDay(LocalDateTime date1, LocalDateTime date2) {
        return date1.getDayOfYear() == date2.getDayOfYear() && date1.getYear() == date2.getYear();
    }

    public boolean isToday(LocalDateTime date) {
        return this.isSameDay(date, this.date.getCurrentDate());
    }

    public boolean isPast(LocalDateTime date) {
        return date.isBefore(this.date.getCurrentDate());
    }

    public int getAge(LocalDateTime birthDate) {
        return Period.between(birthDate.toLocalDate(), this.date.getCurrentDate().toLocalDate()).getYears();
    }

    public double getPercentageBetweenDates(LocalDateTime start, LocalDateTime end) {
        Preconditions.checkArgument((boolean)end.isAfter(start), (Object)"End date must be after start date");
        double duration = ChronoUnit.DAYS.between(start, end);
        double pastDays = ChronoUnit.DAYS.between(start, this.date.getCurrentDate());
        return pastDays / duration;
    }

    public int toDaysCiel(long milliseconds) {
        if (milliseconds == 0L) {
            return 0;
        }
        long nbTicks = milliseconds / 100L;
        int tickUpdateInMinutes = this.date.getTickUpdate();
        long durationInGameMinutes = nbTicks * (long)tickUpdateInMinutes;
        int minutesPerDay = 1440;
        return (int)(durationInGameMinutes / 1440L + 1L);
    }
}

