/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ICreditor;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.LoanerList;
import ch.sahits.game.openpatrician.model.city.impl.Debt;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.city.impl.ILoanProposal;
import ch.sahits.game.openpatrician.model.impl.Citizen;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import ch.sahits.game.openpatrician.utilities.service.RandomNameLoader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class LoanerService {
    @Autowired
    private Random rnd;
    @Autowired
    private Date date;
    @Autowired
    private LoanerList loaners;
    private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");

    public void takeOutLoan(ILoaner loaner, ILoanProposal proposal, IPlayer debitor, ICity city) {
        LocalDateTime now = this.date.getCurrentDate();
        ESocialRank rank = ESocialRank.values()[this.rnd.nextInt(ESocialRank.values().length - 2)];
        Citizen creditor = new Citizen(lastNameLoader.getRandomName(), firstNameLoader.getRandomName(), rank, city);
        LocalDateTime dueDate = now.plusWeeks(proposal.getDurationInWeeks());
        Debt debt = Debt.builder().creditor((ICreditor)creditor).amount(proposal.getAmount()).dueDate(dueDate).interest(proposal.getInterest()).debitor((ICitizen)debitor).loanTakeOut(now).build();
        loaner.addDebt((IDebt)debt);
        loaner.getLoanProposals().remove(proposal);
        if (debitor instanceof IHumanPlayer) {
            debitor.getCompany().updateCash((long)proposal.getAmount());
        } else {
            debitor.getCompany().updateCashDirectly((long)proposal.getAmount());
        }
    }

    public ILoaner findLoaner(ICity city) {
        for (ILoaner iLoaner : this.loaners) {
            if (!iLoaner.getCity().equals(city)) continue;
            return iLoaner;
        }
        return null;
    }

    public List<IDebt> findLoans(ILoaner loaner, IPlayer creditor) {
        ArrayList<IDebt> filteredList = new ArrayList<IDebt>();
        for (IDebt debt : loaner.getDebts()) {
            if (!creditor.equals(debt.getCreditor())) continue;
            filteredList.add(debt);
        }
        return filteredList;
    }

    public List<IDebt> findDebts(ILoaner loaner, IPlayer player) {
        ArrayList<IDebt> filteredList = new ArrayList<IDebt>();
        for (IDebt debt : loaner.getDebts()) {
            if (!player.equals(debt.getDebitor())) continue;
            filteredList.add(debt);
        }
        return filteredList;
    }

    public int calculatePaybacksum(IDebt debt) {
        double totalDuration = debt.getTotalDuration();
        double currentDuration = debt.getLoanedDuration(this.date.getCurrentDate());
        if (currentDuration >= totalDuration) {
            return (int)(debt.getInterest() * (double)debt.getAmount()) + debt.getAmount();
        }
        int value = (int)(debt.getInterest() * (double)debt.getAmount() * currentDuration / totalDuration);
        return value + debt.getAmount();
    }
}

