/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class OutriggerService {
    @Autowired
    private Date date;
    @Autowired
    private IMap map;
    @Value(value="${openpatrician.newGame.startYear:1250}")
    private int firstYear;
    @Value(value="${openpatrician.newGame.endYear:1400}")
    private int lastYear;

    public int getRequiredWeaponStrength(ICity city) {
        int duration = this.lastYear - this.firstYear;
        double xLocation = city.getCoordinates().getX();
        double westwardFactor = 1.0 + (this.map.getDimension().getWidth() - xLocation) / this.map.getDimension().getWidth();
        int currentYear = this.date.getCurrentDate().getYear();
        if (currentYear <= this.firstYear) {
            return (int)westwardFactor;
        }
        int fromStart = currentYear - this.firstYear;
        double yearFactor = (double)fromStart * 9.0 / (double)duration;
        return (int)(westwardFactor * yearFactor);
    }

    public int getWeeklyRefund(ICity city) {
        int duration = this.lastYear - this.firstYear;
        double xLocation = city.getCoordinates().getX();
        double westwardFactor = 1.0 + (this.map.getDimension().getWidth() - xLocation) / this.map.getDimension().getWidth();
        int currentYear = this.date.getCurrentDate().getYear();
        if (currentYear <= this.firstYear) {
            return (int)westwardFactor * 30;
        }
        int from1200 = currentYear - this.firstYear;
        double yearFactor = (double)from1200 * 9.0 / (double)duration;
        return (int)(westwardFactor * yearFactor) * 30;
    }
}

