/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.event;

import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.DisplayTemplateMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ui.DialogTemplate;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class BuyWares
extends TimedTask {
    private final IPlayer player;
    private final ICity city;
    private final AmountablePrice<IWare> amountable;
    private final IWare ware;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;

    public BuyWares(IPlayer player, ICity city, IBuyer buyer) {
        this.setExecutionTime(buyer.getTimeFrame());
        this.player = player;
        this.city = city;
        this.amountable = buyer.getAmountablePrice();
        this.ware = buyer.getWare();
    }

    public void run() {
        ITradingOffice tradingOffice;
        Object amountable;
        Optional optOffice = this.player.findTradingOffice(this.city);
        int amountRequired = this.amountable.getAmount();
        int retrieved = 0;
        if (optOffice.isPresent() && (amountable = (tradingOffice = (ITradingOffice)optOffice.get()).getWare(this.ware)).getAmount() > 0) {
            retrieved = -tradingOffice.move(this.ware, -amountRequired, amountable.getAVGPrice());
        }
        if (retrieved < amountRequired) {
            int toRetrieve;
            AmountablePrice amountable2;
            INavigableVessel ship;
            List ships = this.player.findShips(this.city);
            amountable = ships.iterator();
            while (amountable.hasNext() && (!((ship = (INavigableVessel)amountable.next()) instanceof IShip) || (amountable2 = ship.getWare(this.ware)).getAmount() <= 0 || (retrieved += ship.unload(this.ware, toRetrieve = amountRequired - retrieved)) < amountRequired)) {
            }
        }
        if (retrieved < amountRequired) {
            if (retrieved == 0) {
                if (this.player instanceof IHumanPlayer) {
                    DisplayMessage msg = new DisplayMessage(EMessageCategory.TRADE, "ch.sahits.game.openpatrician.display.event.task.BuyWares.noDelivery", new Object[]{this.ware, this.city.getName()});
                    this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)this.player, (Object)msg));
                }
            } else {
                int payoutSum = (int)Math.rint((double)retrieved * this.amountable.getSum() / (double)amountRequired * 0.9);
                this.player.getCompany().updateCash((long)payoutSum);
                if (this.player instanceof IHumanPlayer) {
                    DialogTemplate template = DialogTemplate.builder().titleKey("ch.sahits.game.openpatrician.display.event.task.BuyWares.partialDeliveryTitle").messageKey("ch.sahits.game.openpatrician.display.event.task.BuyWares.partialDeliveryTemplate").closable(true).build();
                    DisplayTemplateMessage msg = new DisplayTemplateMessage(EMessageCategory.TRADE, "ch.sahits.game.openpatrician.display.event.task.BuyWares.partialDeliveryTitle", template, new Object[]{retrieved, this.ware, this.amountable.getAmount(), this.city.getName()});
                    this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)this.player, (Object)msg));
                }
            }
        } else {
            this.player.getCompany().updateCash((long)((int)this.amountable.getSum()));
            if (this.player instanceof IHumanPlayer) {
                DialogTemplate template = DialogTemplate.builder().titleKey("ch.sahits.game.openpatrician.display.event.task.BuyWares.deliverdAll").messageKey("ch.sahits.game.openpatrician.display.event.task.BuyWares.deliverdAllTemplate").messageArgs(new Object[]{this.amountable.getAmount(), this.ware, this.city.getName(), (int)this.amountable.getSum()}).closable(true).build();
                DisplayTemplateMessage msg = new DisplayTemplateMessage(EMessageCategory.TRADE, "ch.sahits.game.openpatrician.display.event.task.BuyWares.deliverdAll", template, new Object[0]);
                this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)this.player, (Object)msg));
            }
        }
    }

    public String toString() {
        return "BuyWares{UUID=" + this.getUuid() + ", execution at " + this.getExecutionTime() + ", player=" + this.player.getUuid() + " " + this.player.getName() + " " + this.player.getLastName() + ", city=" + this.city.getName() + ", amountable=" + this.amountable + ", ware=" + this.ware + "}";
    }
}

