/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.event;

import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.EMessageCategory;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.time.LocalDateTime;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class PostponedDisplayMessage
extends TimedTask {
    private final EMessageCategory category;
    private final String messageKey;
    private final Object[] messageArgs;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;

    public PostponedDisplayMessage(LocalDateTime executionTime, EMessageCategory category, String messageKey, Object ... messageArgs) {
        this.setExecutionTime(executionTime);
        this.category = category;
        this.messageKey = messageKey;
        this.messageArgs = messageArgs;
    }

    @PostConstruct
    private void initialize() {
        this.taskList.add((TimedTask)this);
    }

    public void run() {
        DisplayMessage msg = new DisplayMessage(this.category, this.messageKey, this.messageArgs);
        this.clientEventBus.post((Object)msg);
    }

    public String toString() {
        return "PostponedDisplayMessage{UUID=" + this.getUuid() + ", execution at " + this.getExecutionTime() + ", category=" + this.category + ", messageKey='" + this.messageKey + "'}";
    }
}

