/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.logging;

import ch.sahits.game.event.data.IClockTick;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import com.google.common.eventbus.EventBus;
import java.lang.reflect.Field;
import javafx.geometry.Point2D;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ClassCategory(value={EClassCategory.HANDLER})
public class EventBusAspect {
    private static final Logger log = LoggerFactory.getLogger(EventBusAspect.class);

    @Pointcut(value="execution(public void com.google.common.eventbus.EventBus.post(Object))")
    public void eventBus() {
    }

    @Before(value="eventBus()")
    public void logEvent(JoinPoint joinPoint) {
        Object event = joinPoint.getArgs()[0];
        if (!this.ignore(event)) {
            String name = ((EventBus)joinPoint.getTarget()).identifier();
            StringBuilder sb = new StringBuilder("Posted event on event bus '").append(joinPoint.getTarget().getClass().getSimpleName()).append(" (").append(name).append(")' ").append(this.format(event));
            if (event instanceof IEventMetaDataProvider) {
                sb.append(" from ").append(((IEventMetaDataProvider)event).getClassName()).append(".").append(((IEventMetaDataProvider)event).getMethodName());
            }
            log.info(sb.toString());
        }
    }

    private boolean ignore(Object event) {
        return event instanceof IClockTick;
    }

    private String format(Object event) {
        if (event instanceof INavigableVessel) {
            return event.getClass().getName() + ": " + this.formatVessel((INavigableVessel)event);
        }
        if (event instanceof IPlayer) {
            return event.getClass().getName() + ": " + this.formatPlayer((IPlayer)event);
        }
        if (event instanceof ICity) {
            return event.getClass().getName() + ": " + this.formatCity((ICity)event);
        }
        StringBuilder sb = new StringBuilder(event.getClass().getName());
        for (Field field : event.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object value = field.get(event);
                if (value instanceof INavigableVessel) {
                    sb.append(" ").append(this.formatVessel((INavigableVessel)value));
                }
                if (value instanceof IPlayer) {
                    sb.append(" ").append(this.formatPlayer((IPlayer)value));
                }
                if (value instanceof ICity) {
                    sb.append(" ").append(this.formatCity((ICity)value));
                }
                if (!(value instanceof Point2D)) continue;
                sb.append(" ").append(((Point2D)value).getX()).append("x").append(((Point2D)value).getY());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    private String formatVessel(INavigableVessel vessel) {
        String s = vessel.getUuid() + ": " + vessel.getName();
        if (vessel.getOwner() instanceof IPlayer) {
            s = s + " of " + this.formatPlayer((IPlayer)vessel.getOwner());
        }
        return s;
    }

    private String formatPlayer(IPlayer player) {
        return player.getUuid() + ": " + player.getName() + " " + player.getLastName();
    }

    private String formatCity(ICity city) {
        return city.getName();
    }
}

