/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.event;

import ch.sahits.game.openpatrician.clientserverinterface.model.event.CelebrationSuccess;
import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.time.LocalDateTime;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class CelebrationState
implements IDialogState {
    private CelebrationSuccess success;
    private int amountGuests;
    private LocalDateTime date;
    private String location;
    private String className;
    private String methodName;

    CelebrationState(CelebrationSuccess success, int amountGuests, LocalDateTime date, String location) {
        this.success = success;
        this.amountGuests = amountGuests;
        this.date = date;
        this.location = location;
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        this.methodName = creatingStackFrame.getMethodName();
        this.className = creatingStackFrame.getClassName();
    }

    public String getDialogBeanName() {
        return "celebrationDialog";
    }

    public static Builder builder() {
        return new Builder();
    }

    public CelebrationSuccess getSuccess() {
        return this.success;
    }

    public int getAmountGuests() {
        return this.amountGuests;
    }

    public LocalDateTime getDate() {
        return this.date;
    }

    public String getLocation() {
        return this.location;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public static class Builder {
        protected CelebrationSuccess success;
        protected int amountGuests;
        protected LocalDateTime date;
        protected String location;

        public Builder success(CelebrationSuccess success) {
            this.success = success;
            return this;
        }

        public Builder amountGuests(int amountGuests) {
            this.amountGuests = amountGuests;
            return this;
        }

        public Builder date(LocalDateTime date) {
            this.date = date;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public CelebrationState build() {
            return new CelebrationState(this.success, this.amountGuests, this.date, this.location);
        }
    }
}

