/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.event;

import ch.sahits.game.openpatrician.model.ui.IDialogState;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import java.time.LocalDateTime;

@ClassCategory(value={EClassCategory.MODEL, EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class DonationRequestState
implements IDialogState {
    private LocalDateTime date;
    private String location;
    private boolean genderMale;
    private int amount;
    private String messageKey;
    private String toLastName;
    private String className;
    private String methodName;
    private boolean accepted = false;

    public DonationRequestState(LocalDateTime date, String location, boolean genderMale, int amount, String messageKey, String toLastName, boolean accepted) {
        this.date = date;
        this.location = location;
        this.genderMale = genderMale;
        this.amount = amount;
        this.messageKey = messageKey;
        this.toLastName = toLastName;
        this.accepted = accepted;
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        this.methodName = creatingStackFrame.getMethodName();
        this.className = creatingStackFrame.getClassName();
    }

    public String getDialogBeanName() {
        return "donationRequestDialog";
    }

    public String toString() {
        return "DonationRequestState{date=" + this.date + ", location='" + this.location + "', genderMale=" + this.genderMale + ", amount=" + this.amount + "}";
    }

    public static DonationRequestStateBuilder builder() {
        return new DonationRequestStateBuilder();
    }

    public LocalDateTime getDate() {
        return this.date;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isGenderMale() {
        return this.genderMale;
    }

    public int getAmount() {
        return this.amount;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public String getToLastName() {
        return this.toLastName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    public static class DonationRequestStateBuilder {
        private LocalDateTime date;
        private String location;
        private boolean genderMale;
        private int amount;
        private String messageKey;
        private String toLastName;
        private boolean accepted;

        DonationRequestStateBuilder() {
        }

        public DonationRequestStateBuilder date(LocalDateTime date) {
            this.date = date;
            return this;
        }

        public DonationRequestStateBuilder location(String location) {
            this.location = location;
            return this;
        }

        public DonationRequestStateBuilder genderMale(boolean genderMale) {
            this.genderMale = genderMale;
            return this;
        }

        public DonationRequestStateBuilder amount(int amount) {
            this.amount = amount;
            return this;
        }

        public DonationRequestStateBuilder messageKey(String messageKey) {
            this.messageKey = messageKey;
            return this;
        }

        public DonationRequestStateBuilder toLastName(String toLastName) {
            this.toLastName = toLastName;
            return this;
        }

        public DonationRequestStateBuilder accepted(boolean accepted) {
            this.accepted = accepted;
            return this;
        }

        public DonationRequestState build() {
            return new DonationRequestState(this.date, this.location, this.genderMale, this.amount, this.messageKey, this.toLastName, this.accepted);
        }

        public String toString() {
            return "DonationRequestState.DonationRequestStateBuilder(date=" + this.date + ", location=" + this.location + ", genderMale=" + this.genderMale + ", amount=" + this.amount + ", messageKey=" + this.messageKey + ", toLastName=" + this.toLastName + ", accepted=" + this.accepted + ")";
        }
    }
}

