/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.event;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.IEventMetaDataProvider;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;

@ClassCategory(value={EClassCategory.EVENT_OBJECT})
public final class OrlegShipOutfittedEvent
implements IEventMetaDataProvider {
    private final IShip ship;
    private final ICity city;
    private final String className;
    private final String methodName;

    public OrlegShipOutfittedEvent(IShip ship, ICity city) {
        this.ship = ship;
        this.city = city;
        StackTraceElement creatingStackFrame = Thread.currentThread().getStackTrace()[2];
        this.methodName = creatingStackFrame.getMethodName();
        this.className = creatingStackFrame.getClassName();
    }

    public IShip getShip() {
        return this.ship;
    }

    public ICity getCity() {
        return this.city;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrlegShipOutfittedEvent)) {
            return false;
        }
        OrlegShipOutfittedEvent other = (OrlegShipOutfittedEvent)o;
        IShip this$ship = this.getShip();
        IShip other$ship = other.getShip();
        if (this$ship == null ? other$ship != null : !this$ship.equals(other$ship)) {
            return false;
        }
        ICity this$city = this.getCity();
        ICity other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        return !(this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IShip $ship = this.getShip();
        result = result * 59 + ($ship == null ? 43 : $ship.hashCode());
        ICity $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
        return result;
    }

    public String toString() {
        return "OrlegShipOutfittedEvent(ship=" + this.getShip() + ", city=" + this.getCity() + ", className=" + this.getClassName() + ", methodName=" + this.getMethodName() + ")";
    }
}

