/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.factory;

import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.initialisation.StartNewGameBean;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.ICog;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.ICrayer;
import ch.sahits.game.openpatrician.model.ship.IHolk;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IShipGroup;
import ch.sahits.game.openpatrician.model.ship.ISnaikka;
import ch.sahits.game.openpatrician.model.ship.ShipProperties;
import ch.sahits.game.openpatrician.model.ship.impl.Cog;
import ch.sahits.game.openpatrician.model.ship.impl.Crayer;
import ch.sahits.game.openpatrician.model.ship.impl.Holk;
import ch.sahits.game.openpatrician.model.ship.impl.Snaikka;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;

@LazySingleton
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ShipFactory {
    private static final Logger log = LoggerFactory.getLogger(ShipFactory.class);
    @Autowired
    private Date date;
    @Autowired
    private IMap map;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private ShipProperties shipProperties;

    public ICrayer createCrayer(String name, int value) {
        Crayer ship = (Crayer)this.context.getBean("crayer", new Object[]{name});
        ship.setSize(value);
        return ship;
    }

    public ICrayer createCrayer(String name, EShipUpgrade upgradeLevel, int value) {
        Crayer ship = (Crayer)this.context.getBean("crayer", new Object[]{upgradeLevel, name});
        ship.setSize(value);
        log.info("Create a Crayer: " + ship + ". uuid=" + ship.getUuid() + ", " + ship);
        return ship;
    }

    public ISnaikka createSnaikka(String name, int value) {
        Snaikka snaikka = (Snaikka)this.context.getBean("snaikka", new Object[]{name});
        snaikka.setSize(value);
        return snaikka;
    }

    public ISnaikka createSnaikka(String name, EShipUpgrade upgradeLevel, int value) {
        Snaikka snaikka = (Snaikka)this.context.getBean("snaikka", new Object[]{upgradeLevel, name});
        snaikka.setSize(value);
        return snaikka;
    }

    public ICog createCog(String name, int value) {
        Cog ship = (Cog)this.context.getBean("cog", new Object[]{name});
        ship.setSize(value);
        return ship;
    }

    public ICog createCog(String name, EShipUpgrade upgradeLevel, int value) {
        Cog ship = (Cog)this.context.getBean("cog", new Object[]{upgradeLevel, name});
        ship.setSize(value);
        return ship;
    }

    public IHolk createHolk(String name, int value) {
        Holk ship = (Holk)this.context.getBean("holk", new Object[]{name});
        ship.setSize(value);
        return ship;
    }

    public IHolk createHolk(String name, EShipUpgrade upgradeLevel, int value) {
        Holk ship = (Holk)this.context.getBean("holk", new Object[]{upgradeLevel, name});
        ship.setSize(value);
        return ship;
    }

    public int calculateInitialCapacity(EShipType type, double x) {
        double startYearPart = Math.max((this.date.getCurrentDate().getYear() - 1430) / 100, 0);
        int mapWidth = (int)this.map.getDimension().getWidth();
        double eastFactor = x / (double)mapWidth / 0.5;
        double factor = Math.max(startYearPart - eastFactor, 0.0);
        switch (type) {
            case SNAIKKA: {
                ShipProperties.Capacity snaikkaCapacity = this.shipProperties.getSnaikka().getCapacity();
                int sizeDiff = snaikkaCapacity.getMax() - snaikkaCapacity.getMin();
                return (int)((double)snaikkaCapacity.getMin() + Math.rint(factor * (double)sizeDiff));
            }
            case CRAYER: {
                ShipProperties.Capacity crayerCapacity = this.shipProperties.getCrayer().getCapacity();
                int sizeDiff = crayerCapacity.getMax() - crayerCapacity.getMin();
                return (int)((double)crayerCapacity.getMin() + Math.rint(factor * (double)sizeDiff));
            }
            case COG: {
                ShipProperties.Capacity cogCapacity = this.shipProperties.getCog().getCapacity();
                int sizeDiff = cogCapacity.getMax() - cogCapacity.getMin();
                return (int)((double)cogCapacity.getMin() + Math.rint(factor * (double)sizeDiff));
            }
            case HOLK: {
                ShipProperties.Capacity holkCapacity = this.shipProperties.getHolk().getCapacity();
                int sizeDiff = holkCapacity.getMax() - holkCapacity.getMin();
                return (int)((double)holkCapacity.getMin() + Math.rint(factor * (double)sizeDiff));
            }
        }
        return 0;
    }

    public int getUpgradeAmount(EShipType type, EWare ware) {
        int typeAddition = 0;
        switch (type) {
            case SNAIKKA: {
                typeAddition = 0;
                break;
            }
            case CRAYER: {
                typeAddition = 1;
                break;
            }
            case COG: {
                typeAddition = 2;
                break;
            }
            case HOLK: {
                typeAddition = 3;
            }
        }
        switch (ware) {
            case WOOD: {
                return 2 + typeAddition;
            }
            case PITCH: 
            case IRON: {
                return 1 + typeAddition;
            }
        }
        return 0;
    }

    public int getConstructionAmount(EShipType type, EWare ware) {
        switch (type) {
            case SNAIKKA: {
                switch (ware) {
                    case WOOD: {
                        return 11;
                    }
                    case CLOTH: {
                        return 3;
                    }
                    case IRON: {
                        return 3;
                    }
                    case HEMP: {
                        return 3;
                    }
                    case PITCH: {
                        return 20;
                    }
                }
                return 0;
            }
            case CRAYER: {
                switch (ware) {
                    case WOOD: {
                        return 16;
                    }
                    case CLOTH: {
                        return 5;
                    }
                    case IRON: {
                        return 5;
                    }
                    case HEMP: {
                        return 5;
                    }
                    case PITCH: {
                        return 30;
                    }
                }
                return 0;
            }
            case COG: {
                switch (ware) {
                    case WOOD: {
                        return 22;
                    }
                    case CLOTH: {
                        return 3;
                    }
                    case IRON: {
                        return 4;
                    }
                    case HEMP: {
                        return 4;
                    }
                    case PITCH: {
                        return 40;
                    }
                }
                return 0;
            }
            case HOLK: {
                switch (ware) {
                    case WOOD: {
                        return 36;
                    }
                    case CLOTH: {
                        return 10;
                    }
                    case IRON: {
                        return 10;
                    }
                    case HEMP: {
                        return 8;
                    }
                    case PITCH: {
                        return 50;
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    public int getMinimalSailors(EShipType type) {
        switch (type) {
            case SNAIKKA: {
                return 5;
            }
            case CRAYER: {
                return 8;
            }
            case COG: {
                return 10;
            }
            case HOLK: {
                return 15;
            }
        }
        return 0;
    }

    public int getShipSpeed(EShipType type) {
        switch (type) {
            case SNAIKKA: {
                return 5;
            }
            case CRAYER: {
                return 6;
            }
            case COG: {
                return 4;
            }
            case HOLK: {
                return 5;
            }
        }
        return 0;
    }

    public IConvoy getConvoy(IShip ship, boolean isPublicConvoy) {
        return (IConvoy)this.context.getBean("convoy", new Object[]{ship, isPublicConvoy});
    }

    public IShipGroup getShipGroup(IShip leadShip) {
        return (IShipGroup)this.context.getBean("shipGroup", new Object[]{leadShip});
    }
}

