/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.model.task;

import ch.sahits.game.openpatrician.clientserverinterface.model.task.ReschedulableSailorHireTask;
import ch.sahits.game.openpatrician.clientserverinterface.service.ClientServerTaskFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.ShipService;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IAIPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.ISailorState;
import ch.sahits.game.openpatrician.model.player.BuyWeapons;
import ch.sahits.game.openpatrician.model.player.IAIBuyWeaponStrategy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN, EClassCategory.SERIALIZABLE_BEAN})
@Prototype
public class ReschedulableWeaponBuyTask
extends TimedTask {
    private final IShip ship;
    private final BuyWeapons weaponsToBuy;
    private final ICity city;
    @Autowired
    @XStreamOmitField
    private ShipService shipService;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    @Qualifier(value="serverSideTaskFactory")
    private ClientServerTaskFactory taskFactory;

    public ReschedulableWeaponBuyTask(IShip ship, BuyWeapons weaponsToBuy, ICity city) {
        this.ship = ship;
        this.weaponsToBuy = weaponsToBuy;
        this.city = city;
    }

    public void run() {
        IAIPlayer player = (IAIPlayer)this.ship.getOwner();
        IAIBuyWeaponStrategy weaponStrategy = (IAIBuyWeaponStrategy)player.getWeaponBuyStrategyType().getStrategy();
        weaponStrategy.buyWeaponsOrdered(this.weaponsToBuy, this.ship, player, this.city);
        if (this.weaponsToBuy.getTotalStrength() > this.shipService.calculateShipsWeaponsStrength((INavigableVessel)this.ship)) {
            this.setExecutionTime(this.date.getCurrentDate().plusDays(1L));
            this.taskList.add((TimedTask)this);
        } else {
            ISailorState sailorState = this.city.getCityState().getTavernState().getSailors();
            ReschedulableSailorHireTask hireSailors = this.taskFactory.getReschedulableSailorHireTask(this.ship, sailorState, this.ship.getMaxNumberOfSailors(), this.city);
            hireSailors.run();
        }
    }

    public String toString() {
        return "ReschedulableWeaponBuyTask{UUID=" + this.getUuid() + ", execution at " + this.getExecutionTime() + ", ship=" + this.ship.getUuid() + " " + this.ship.getName() + ", city=" + this.city.getName() + "}";
    }
}

