/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.openpatrician.clientserverinterface.service.DateService;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.guild.GuildSettings;
import ch.sahits.game.openpatrician.model.city.guild.IAuction;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class GuildService {
    private static final int MAX_COMPANY_VALUE = 1000000;
    private static final int MIN_COMPANY_VALUE = 50000;
    @Autowired
    private GuildSettings guildSettings;
    @Autowired
    private DateService dateService;
    @Autowired
    private Date date;

    public int getEntryFee(IPlayer player) {
        long companyValue = player.getCompany().getCompanyValue();
        int min = this.guildSettings.getMinEntryFee();
        int max = this.guildSettings.getMaxEntryFee();
        int span = max - min;
        if (companyValue <= 50000L) {
            return min;
        }
        if (companyValue >= 1000000L) {
            return max;
        }
        double factor = (double)companyValue * 1.0 / 1000000.0;
        double fee = (double)min + (double)span * factor;
        return (int)Math.rint(fee);
    }

    public LocalDateTime cleanUpAuctionAndDetermineAuctionDate(LocalDateTime auctionDate, IGuild guild) {
        if (!guild.getAuctions().isEmpty()) {
            for (IAuction nextAuction : guild.getAuctions()) {
                if (this.dateService.isPast(nextAuction.getAuctionDate())) {
                    nextAuction.setAuctionDate(this.date.getCurrentDate().plusDays(1L));
                }
                while (this.dateService.isSameDay(nextAuction.getAuctionDate(), auctionDate)) {
                    auctionDate = auctionDate.plusDays(1L);
                }
            }
        }
        return auctionDate;
    }
}

