/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.IChurch;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.AldermanTaskPlayerMap;
import ch.sahits.game.openpatrician.model.city.cityhall.CityHallList;
import ch.sahits.game.openpatrician.model.city.cityhall.IAldermanTask;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.collection.CityChurchRegistry;
import ch.sahits.game.openpatrician.model.collection.CityTavernRegistry;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import org.springframework.beans.factory.annotation.Autowired;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ModelStateAccessor {
    @Autowired
    private CityChurchRegistry churchMap;
    @Autowired
    private CityHallList cityHalls;
    @Autowired
    private AldermanTaskPlayerMap takenTasks;
    @Autowired
    private CityTavernRegistry cities;

    public IChurch getChurch(ICity city) {
        return (IChurch)this.churchMap.get((Object)city);
    }

    public ICityHall getCityHall(ICity city) {
        for (ICityHall cityHall : this.cityHalls) {
            ICity cityHallCity = cityHall.getCity();
            if (!cityHallCity.equals(city)) continue;
            return cityHall;
        }
        return null;
    }

    public void assignTask(IPlayer player, IAldermanTask task) {
        this.takenTasks.assignTask(player, task);
    }

    public TavernState getTavernState(ICity city) {
        return (TavernState)this.cities.get((Object)city);
    }
}

