/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.clientserverinterface.service;

import ch.sahits.game.openpatrician.clientserverinterface.model.PathInterpolatorMap;
import ch.sahits.game.openpatrician.clientserverinterface.model.VesselPositionUpdateData;
import ch.sahits.game.openpatrician.clientserverinterface.model.WeaponSlotCount;
import ch.sahits.game.openpatrician.clientserverinterface.service.DateService;
import ch.sahits.game.openpatrician.clientserverinterface.service.IPathConverter;
import ch.sahits.game.openpatrician.clientserverinterface.service.OutriggerService;
import ch.sahits.game.openpatrician.clientserverinterface.service.PathInterpolator;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.sea.TravellingVessel;
import ch.sahits.game.openpatrician.model.sea.TravellingVessels;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.ship.ICog;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.ICrayer;
import ch.sahits.game.openpatrician.model.ship.IGroupableVessel;
import ch.sahits.game.openpatrician.model.ship.IHolk;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IShipGroup;
import ch.sahits.game.openpatrician.model.ship.ISnaikka;
import ch.sahits.game.openpatrician.model.ship.IWeaponSlot;
import ch.sahits.game.openpatrician.model.ship.PrimaryLargeWeaponSlot;
import ch.sahits.game.openpatrician.model.ship.SecondaryLargeWeaponSlot;
import ch.sahits.game.openpatrician.model.ship.SmallWeaponSlot;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javafx.geometry.Point2D;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ShipService {
    public static final int CITY_RADIUS = 10;
    private static final double ONE_KMPH_TO_KNOTS = 0.539957;
    @Autowired
    private IMap map;
    @Autowired
    private OutriggerService outriggerService;
    @Autowired
    private PathInterpolatorMap pathInterpolatorMap;
    @Autowired
    private DateService dateService;
    @Autowired
    private TravellingVessels travellingVessels;
    @Autowired
    private ApplicationContext context;
    private IPathConverter pathConverter;

    private IPathConverter getPathConverter() {
        if (this.pathConverter == null) {
            this.pathConverter = (IPathConverter)this.context.getBean("pathConverter");
        }
        return this.pathConverter;
    }

    public int calculateShipsWeaponsStrength(INavigableVessel ship) {
        double strength = 0.0;
        strength += (double)ship.getWeaponAmount((IWeapon)EWeapon.BALLISTA_BIG) * EWeapon.BALLISTA_BIG.getStrength();
        strength += (double)ship.getWeaponAmount((IWeapon)EWeapon.TREBUCHET_BIG) * EWeapon.TREBUCHET_BIG.getStrength();
        strength += (double)ship.getWeaponAmount((IWeapon)EWeapon.CANNON) * EWeapon.CANNON.getStrength();
        strength += (double)ship.getWeaponAmount((IWeapon)EWeapon.BOMBARD) * EWeapon.BOMBARD.getStrength();
        strength += (double)ship.getWeaponAmount((IWeapon)EWeapon.BALLISTA_SMALL) * EWeapon.BALLISTA_SMALL.getStrength();
        return (int)Math.rint(strength += (double)ship.getWeaponAmount((IWeapon)EWeapon.TREBUCHET_SMALL) * EWeapon.TREBUCHET_SMALL.getStrength());
    }

    public Optional<INavigableVessel> findShipByUuid(List<INavigableVessel> fleet, String uuid) {
        for (INavigableVessel vessel : fleet) {
            if (!uuid.equals(vessel.getUuid())) continue;
            return Optional.of(vessel);
        }
        return Optional.empty();
    }

    public Optional<ICity> findCity(INavigableVessel vessel) {
        Point2D location = vessel.getLocation();
        for (ICity city : this.map.getCities()) {
            if (!city.getCoordinates().equals((Object)location)) continue;
            return Optional.of(city);
        }
        return Optional.empty();
    }

    public int calculateRepairCosts(ICity city, IShip ship) {
        IShipyard state = city.getCityState().getShipyardState();
        int damage = (int)Math.rint((double)(100 - ship.getDamage()) / 100.0);
        int repairTime = state.calculateRepairTime(ship.getShipType());
        int materialCosts = state.calculateRepairMaterialCosts(ship, damage);
        return state.calculateRepairCosts(repairTime *= damage, materialCosts);
    }

    public int calculateRepairCostsVessel(ICity city, INavigableVessel vessel) {
        int sum = 0;
        if (vessel instanceof IConvoy) {
            for (IShip ship : ((IConvoy)vessel).getShips()) {
                sum += this.calculateRepairCosts(city, ship);
            }
        } else if (vessel instanceof IShipGroup) {
            for (IShip ship : ((IShipGroup)vessel).getShips()) {
                sum += this.calculateRepairCosts(city, ship);
            }
        } else {
            throw new IllegalStateException("Unhandled vessel type: " + vessel.getClass().getName());
        }
        return sum;
    }

    public boolean checkNumberOfSailors(INavigableVessel vessel) {
        if (vessel instanceof IShip) {
            IShip ship = (IShip)vessel;
            return ship.getNumberOfSailors() >= ship.getMinNumberOfSailors();
        }
        IGroupableVessel group = (IGroupableVessel)vessel;
        for (IShip ship : group.getShips()) {
            if (this.checkNumberOfSailors((INavigableVessel)ship)) continue;
            return false;
        }
        return true;
    }

    public boolean canReachDestination(INavigableVessel vessel, Point2D destination) {
        Optional optCity;
        EShipType type = this.getShipType(vessel);
        if ((type == EShipType.HOLK || type == EShipType.COG) && (optCity = this.map.findCity(destination)).isPresent()) {
            return !((ICity)optCity.get()).isRiverCity();
        }
        return true;
    }

    public boolean isShipTooDamagedToSail(INavigableVessel vessel) {
        return vessel.getDamage() >= 90;
    }

    public int getMinNumberOfSailors(INavigableVessel vessel) {
        if (vessel instanceof IShip) {
            return ((IShip)vessel).getMinNumberOfSailors();
        }
        IGroupableVessel ships = (IGroupableVessel)vessel;
        int number = 0;
        for (IShip ship : ships.getShips()) {
            number += ship.getMinNumberOfSailors();
        }
        return number;
    }

    public boolean isNearingCity(INavigableVessel vessel) {
        Point2D location = vessel.getLocation();
        for (ICity city : this.map.getCities()) {
            Point2D coordinates = city.getCoordinates();
            double distance = coordinates.distance(location);
            if (!(distance <= 10.0)) continue;
            return true;
        }
        return false;
    }

    public EShipType getShipType(INavigableVessel vessel) {
        if (vessel instanceof IHolk) {
            return EShipType.HOLK;
        }
        if (vessel instanceof ICog) {
            return EShipType.COG;
        }
        if (vessel instanceof ICrayer) {
            return EShipType.CRAYER;
        }
        if (vessel instanceof ISnaikka) {
            return EShipType.SNAIKKA;
        }
        if (vessel instanceof IGroupableVessel) {
            List ships = ((IGroupableVessel)vessel).getShips();
            HashSet<EShipType> types = new HashSet<EShipType>();
            for (IShip ship : ships) {
                types.add(this.getShipType((INavigableVessel)ship));
            }
            if (types.contains(EShipType.HOLK)) {
                return EShipType.HOLK;
            }
            if (types.contains(EShipType.COG)) {
                return EShipType.COG;
            }
            if (types.contains(EShipType.CRAYER)) {
                return EShipType.CRAYER;
            }
            if (types.contains(EShipType.SNAIKKA)) {
                return EShipType.SNAIKKA;
            }
        }
        return EShipType.HOLK;
    }

    public boolean isOrlegCapable(IShip ship, ICity city) {
        if (ship.getCaptian().isPresent() && ship.getNumberOfSailors() >= 20) {
            int shipStrength;
            int requiredWeaponStrength = this.outriggerService.getRequiredWeaponStrength(city);
            return requiredWeaponStrength <= (shipStrength = this.calculateShipsWeaponsStrength((INavigableVessel)ship));
        }
        return false;
    }

    public WeaponSlotCount getWeaponSlotCount(List<IWeaponSlot> weaponSlots) {
        int nbLargeSlots = 0;
        int nbSmallSlots = 0;
        for (IWeaponSlot weaponSlot : weaponSlots) {
            if (weaponSlot instanceof SmallWeaponSlot) {
                ++nbSmallSlots;
                continue;
            }
            ++nbLargeSlots;
        }
        return new WeaponSlotCount(nbSmallSlots, nbLargeSlots /= 2);
    }

    public boolean placeWeapon(EWeapon weapon, IShip ship) {
        Preconditions.checkNotNull((Object)weapon);
        Preconditions.checkNotNull((Object)ship);
        boolean smallWeapon = this.isSmallWeapon(weapon);
        boolean largeWeapon = this.isLargeWeapon(weapon);
        Preconditions.checkArgument((smallWeapon || largeWeapon || weapon == EWeapon.HAND_WEAPON ? 1 : 0) != 0, (Object)"Weapon must be ship weapon");
        if (weapon == EWeapon.HAND_WEAPON) {
            ship.updateHandweapon(1);
            return true;
        }
        List slots = ship.getWeaponSlots();
        for (int i = 0; i < slots.size(); ++i) {
            IWeaponSlot slot = (IWeaponSlot)slots.get(i);
            if (smallWeapon && !slot.getWeapon().isPresent()) {
                slot.setWeapon((IWeapon)weapon);
                return true;
            }
            if (!largeWeapon || !(slot instanceof PrimaryLargeWeaponSlot)) continue;
            SecondaryLargeWeaponSlot secondary = (SecondaryLargeWeaponSlot)slots.get(i + 1);
            if (slot.getWeapon().isPresent() || secondary.getWeapon().isPresent()) continue;
            slot.setWeapon((IWeapon)weapon);
            secondary.combineWithBigSlot((PrimaryLargeWeaponSlot)slot);
            return true;
        }
        return false;
    }

    public boolean removeWeapon(EWeapon weapon, IShip ship) {
        Preconditions.checkNotNull((Object)weapon);
        Preconditions.checkNotNull((Object)ship);
        boolean smallWeapon = this.isSmallWeapon(weapon);
        boolean largeWeapon = this.isLargeWeapon(weapon);
        Preconditions.checkArgument((smallWeapon || largeWeapon || weapon == EWeapon.HAND_WEAPON ? 1 : 0) != 0, (Object)"Weapon must be ship weapon");
        if (weapon == EWeapon.HAND_WEAPON) {
            ship.updateHandweapon(-1);
            return true;
        }
        List slots = ship.getWeaponSlots();
        for (int i = slots.size() - 1; i >= 0; --i) {
            IWeaponSlot slot = (IWeaponSlot)slots.get(i);
            Optional optWeapon = slot.getWeapon();
            if (smallWeapon && optWeapon.isPresent()) {
                if (!weapon.equals(optWeapon.get())) continue;
                slot.setWeapon(null);
                return true;
            }
            if (!largeWeapon || !(slot instanceof PrimaryLargeWeaponSlot) || !optWeapon.isPresent() || !weapon.equals(optWeapon.get())) continue;
            SecondaryLargeWeaponSlot secondary = (SecondaryLargeWeaponSlot)slots.get(i + 1);
            slot.setWeapon(null);
            secondary.setWeapon(null);
            return true;
        }
        return false;
    }

    public boolean isLargeWeapon(EWeapon weapon) {
        switch (weapon) {
            case TREBUCHET_BIG: 
            case BALLISTA_BIG: 
            case BOMBARD: {
                return true;
            }
        }
        return false;
    }

    private boolean isSmallWeapon(EWeapon weapon) {
        switch (weapon) {
            case TREBUCHET_SMALL: 
            case BALLISTA_SMALL: 
            case CANNON: {
                return true;
            }
        }
        return false;
    }

    public int convertSpeedToKnots(IShip ship) {
        return (int)Math.rint(ship.getCurrentSpeed() * 0.539957);
    }

    public double percentageOfMaxSpeed(IShip ship) {
        return ship.getCurrentSpeed() / ship.getTopSpeed();
    }

    public int calculateDaysTillArrival(INavigableVessel vessel) {
        VesselPositionUpdateData positionData = this.pathInterpolatorMap.get(vessel);
        if (positionData == null) {
            return 0;
        }
        PathInterpolator interpolator = positionData.getInterpolator();
        double traveledFraction = interpolator.getTraveldFraction();
        double fractionToTravel = 1.0 - traveledFraction;
        long remainingDurationMsInRealTime = this.getPathConverter().calculateDuration(vessel, interpolator, fractionToTravel);
        return this.dateService.toDaysCiel(remainingDurationMsInRealTime);
    }

    public Optional<ICity> getDestinationCity(INavigableVessel vessel) {
        Optional<ICity> inCity = this.findCity(vessel);
        if (inCity.isPresent()) {
            return inCity;
        }
        TravellingVessel travelling = this.travellingVessels.getTravellingVessel(vessel);
        Point2D destination = (Point2D)travelling.getCalculatablePath().get(travelling.getCalculatablePath().size() - 1);
        return this.map.getCities().stream().filter(city -> city.getCoordinates().equals((Object)destination)).findFirst();
    }
}

