package ch.sahits.game;

import java.util.LinkedList;
import java.util.List;

import ch.sahits.game.openpatrician.client.IClient;
import ch.sahits.game.openpatrician.model.IGame;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.IPlayer;
/**
 * Client representation of the game
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Sep 18, 2011
 *
 */
public class Client implements IClient {
	
	private final IPlayer player;
	private IGame game=null;
	private List<IPlayer> competitor = new LinkedList<IPlayer>();

	public Client(IPlayer player) {
		super();
		this.player = player;
	}

	@Override
	public IPlayer getPlayer() {
		return player;
	}

	@Override
	public IMap getGameMap() {
		return game.getMap();
	}

	@Override
	public void initGame(IGame game) {
		if (this.game==null){
			this.game=game;
		}
	}

	@Override
	public void addCompetitor(IPlayer player) {
		competitor.add(player);
		
	}

	@Override
	public IGame getGame() {
		return game;
	}

}
