package ch.sahits.game;

import javax.swing.JFrame;

import ch.sahits.game.graphic.display.OpenPatricianFrame;

public class OpenPatrician {
	
	private final static String START_CLIENT = "-c";
	private final static String START_SERVER = "-s";
	private final static String HELP = "?";
	
	private volatile static boolean startedServer = false;
	
	private final static Object lock = new Object();

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		boolean startServer = false;
//		if (args.length>0){
//			for (int i = 0; i < args.length; i++) {
//				if (args[i].equals(START_CLIENT)){
//					startServer=false;
//				} else if (args[i].equals(START_SERVER)){
//					startServer=true;
//				} else if (args[i].equals(HELP)){
//					printUsage();
//					System.exit(0);
//				}
//			}
//		}
		if (startServer){
			System.out.println("Multiplayer game is not yet implemented, sorry.");
			System.exit(0);
		} else {
			OpenPatricianFrame opf = new OpenPatricianFrame();
			opf.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			opf.setVisible(true);
		}

	}

	private static void printUsage() {
		StringBuilder sb = new StringBuilder();
		String prefix = "       ";
		sb.append("Usage: ").append(OpenPatrician.class.getName()).append(" [-c|-s] [?]\n");
		sb.append("\n").append(prefix).append(HELP).append("    ").append("Print this help message\n");
		sb.append(prefix).append(START_SERVER).append("   ").append("Start the server part of the application only\n");
		sb.append(prefix).append(START_CLIENT).append("   ").append("Start the client for the application. This allows connecting to a running server or run a standalone game\n");
		sb.append(prefix).append("     ").append("Calling with this argument is the same as calling without any argument");
		
		System.out.println(sb.toString());
	}
	/**
	 * Create the server instance for a standalone game. If the server is already started no
	 * second server will be started.
	 * @param userGui Thread/Runnable that handels the users GUI rendering
	 */
	public static void createStandaloneServer(OpenPatricianFrame userGui){
		synchronized (lock) {
			if (startedServer) return; // only start the server once
		}
		// PRE: The server is not yet started
		// TODO: create server with AI players and one human player
	}
	
	// TODO add method connectToServer

}
