package ch.sahits.game.graphic.display;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.Event;
import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.display.start.NewGameView;
import ch.sahits.game.graphic.display.start.StartupView;
import ch.sahits.game.graphic.image.FontLoader;
import ch.sahits.game.openpatrician.client.IClient;
import ch.sahits.game.openpatrician.client.event.IMainGameView;
import ch.sahits.game.rendering.BaseView;
import ch.sahits.game.rendering.RenderablePart;
import ch.sahits.util.ClassChecker;
/**
 * This View represents the main game view
 * @author andi
 *
 */
public class GameView extends BaseView implements IMainGameView{
	private boolean enabled = true;
	private final FontLoader fontLoader = FontLoader.getInstance();
	private IClient client;
	
	/**
	 * @param width
	 * @param height
	 */
	public GameView(Rectangle bounds,OpenPatricianFrame parent) {
		super(bounds,parent);
System.out.println("GameView: "+bounds);
		createStartupView();
		createNewView();
	}

	private void createStartupView() {
		StartupView sv = new StartupView(rect);
		addPart(sv);
	}
	private void createNewView(){
		try {
			Font font = fontLoader.createDefaultFont(24);
			NewGameView view = new NewGameView(rect,getParent().getFontMetrics(font));
			view.setEnabled(false);
			addPart(view);
		} catch (FontFormatException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	@Override
	public void gameRender(Graphics gScr) {
		Color oldColor = gScr.getColor();
		for (Iterator<RenderablePart> iter = iterator(); iter.hasNext();) {
			RenderablePart part = iter.next();
			if (part.isEnabled()){
				part.gameRender(gScr);
			}
		}
		
		gScr.setColor(oldColor);
	}


	@Override
	public boolean isEnabled() {
		return enabled;
	}

	@Override
	public void setEnabled(boolean flag) {
		enabled=flag;
		for (Iterator<RenderablePart> iter = iterator(); iter.hasNext();) {
			RenderablePart part = iter.next();
			part.setEnabled(flag);
		}
	}

	@Override
	public final void gameUpdate(Event e, Object notice) {
		if (e instanceof ViewChangeEvent){
			ViewChangeEvent event = (ViewChangeEvent) e;
			ClassChecker cc = new ClassChecker(getClass());
			if (event.getAddresse().equals(getClass()) ||
					cc.implementsInterfaceIndirectly(event.getAddresse())){
				if (notice instanceof EViewChangeEvent){
					EViewChangeEvent change = (EViewChangeEvent) notice;
					switch (change) {
					case DISPLAY_NEW_SP:
						for (Iterator<RenderablePart> iter = iterator(); iter.hasNext();) {
							RenderablePart part = iter.next();
							if (part instanceof NewGameView){
								part.setEnabled(true);
							} else {
								part.setEnabled(false);
							}
						}
						break;
					case START_GAME:
						LinkedList<RenderablePart> startupParts = new LinkedList<RenderablePart>();
						for (Iterator<RenderablePart> iter = iterator(); iter.hasNext();) {
							RenderablePart part = iter.next();
							startupParts.add(part);
						}
						MainGameView mainGame = new MainGameView(getBounds(),client);
						mainGame.setEnabled(true);
						addPart(mainGame);
						// remove the old parts
						for (RenderablePart part : startupParts) {
							removePart(part);
						}
						break;
					default:
						// Do not handle any other change events
						break;
					}
				}
			}
		}
	}
	/**
	 * Retrieve the main game view that is currently active
	 * @return
	 */
	public final RenderablePart getActiveMainView(){
		for (Iterator<RenderablePart> iter = iterator(); iter.hasNext();) {
			RenderablePart part = iter.next();
//			if (part instanceof StatusView){
//				continue;
//			}
//			if (part instanceof TrainOverview){
//				continue;
//			}
//			if (part instanceof MapOverview){
//				continue;
//			}
//			if (part instanceof GameMenu){
//				continue;
//			}
			if (part.isEnabled()){
				return part;
			}
		}
		return null;
	}

	public void setClient(IClient client) {
		this.client = client;
	}

}
