package ch.sahits.game.graphic.display;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.LinkedList;

import ch.sahits.game.event.Event;
import ch.sahits.game.event.KeyPressEvent;
import ch.sahits.game.event.MouseClickEvent;
import ch.sahits.game.graphic.image.OpenPatricianPainter;
import ch.sahits.game.rendering.AbstractRenderPart;
import ch.sahits.game.rendering.RenderablePart;
/**
 * This {@link RenderablePart} implementation is a base implementation for brick walled
 * background on which form elements can be placed.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Sep 3, 2011
 *
 */
public class OpenPatricianBackgroundView extends AbstractRenderPart implements ISahitsContainer {
	private LinkedList<IUpdatableComponent> updatables = new LinkedList<IUpdatableComponent>();
	private LinkedList<ISahitsComponent> components = new LinkedList<ISahitsComponent>();
	
	private final ISahitsLayoutManager layoutManager;	

	public OpenPatricianBackgroundView(Rectangle rect, ISahitsLayoutManager layoutManager) {
		super(rect);
		this.layoutManager = layoutManager;
		Event.add(this);
	}

	public void add(ISahitsComponent comp, ISahitsLayoutConstraint constraint) {
		components.add(comp);
		layoutManager.addLayoutComponent(comp, constraint);
		if (comp instanceof IUpdatableComponent){
			updatables.add((IUpdatableComponent) comp);
		}
	}

	@Override
	public void gameRender(Graphics gScr) {
		if (isEnabled()){
			String tileName = "RedBrickWallTiled2.png";
			OpenPatricianPainter.drawBackground(gScr, tileName, getBounds());
			layoutManager.layoutContainer(this);
			for (ISahitsComponent comp : components) {
				comp.paint(gScr);
			}
		}
	}

	@Override
	public void gameUpdate(Event e, Object notice) {
		if (e instanceof MouseClickEvent){
			for (IUpdatableComponent comp : updatables) {
				comp.testClick((Point)notice);
			}
		}
		if (e instanceof KeyPressEvent){
			KeyPressEvent event = (KeyPressEvent) e;
			for (IUpdatableComponent comp : updatables) {
				comp.testKeyPress(event.getKey());
			}
		}

	}

	@Override
	public int getComponentCount() {
		return components.size();
	}


	@Override
	public ISahitsComponent get(int i) {
		return components.get(i);
	}

	@Override
	public Insets getInsets() {
		return new Insets(0, 0, 0, 0);
	}

	@Override
	public int getHeight() {
		return getBounds().height;
	}

	@Override
	public int getWidth() {
		return getBounds().width;
	}
}
