package ch.sahits.game.graphic.display;

import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;

import ch.sahits.game.Client;
import ch.sahits.game.event.Event;
import ch.sahits.game.event.IEventListener;
import ch.sahits.game.event.KeyPressEvent;
import ch.sahits.game.event.MouseClickEvent;
import ch.sahits.game.event.MouseMoveEvent;
import ch.sahits.game.event.NewGameEvent;
import ch.sahits.game.openpatrician.client.GameRunnable;
import ch.sahits.game.openpatrician.client.IClient;
import ch.sahits.game.openpatrician.model.IGame;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.server.OpenPatricianServer;
import ch.sahits.game.rendering.MainFrame;
/**
 * This is the GUI frame for the OpenPatrician game
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Sep 2, 2011
 *
 */
public class OpenPatricianFrame extends MainFrame implements IEventListener, GameRunnable{
	/**
	 * Client data representation
	 */
	private IClient client;
	private GameView view;
	
    public OpenPatricianFrame() {
    	super("OpenPatrician");
//       GameClock.getInstance(startYear);
		createGameView();

		gameStart();
		Event.add(this);
    }
    
    private void createGameView(){
     	view = new GameView(getRactangle(), this);
    	addView( view);
    }
    
    
    
	protected final void closeWindow(){
		// TODO notify server
		super.closeWindow();
	}

	/**
	 * Check the mouse clicks
	 * 
	 * @param x
	 * @param y
	 */
	protected final void testPress(int x, int y)
	{
System.out.println("Mouse clicked at "+x+","+y);
		new MouseClickEvent().notify(new Point(x,y));
	} // end of testPress()

	/**
	 * Handle the mouse movement (e.g. for hovering effects or tooltips )
	 * 
	 * @param x
	 * @param y
	 */
	protected final void testMove(int x, int y)
	// is (x,y) over the pause or quit buttons?
	{
		new MouseMoveEvent().notify(new Point(x,y));
	}
	/**
	 * Handle key presses
	 * @param key
	 */
	protected final void testKey(KeyEvent key){
		new KeyPressEvent(key).notify(null);
	}


	protected final void gameUpdate() { // The updates event may not be driven only by the cycle
	} // end of gameUpdate()
	


	@Override
	public void windowClosing(WindowEvent e) {
		// TODO notify server
	}

	@Override
	public void windowClosed(WindowEvent e) {
		// TODO notify server	
	}

//	public static void main(String[] args){
//		OpenPatricianFrame opf = new OpenPatricianFrame();
//		opf.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
//		opf.setVisible(true);
//
//	}
	@Override
	public void gameUpdate(Event e, Object eventNotice) {
		if (e instanceof KeyPressEvent){
			KeyEvent key= ((KeyPressEvent)e).getKey();
			if (key.isControlDown() && key.getKeyCode()==KeyEvent.VK_Q){
				closeWindow();
			}
		}
		// New Game events
		if (e instanceof NewGameEvent){
			NewGameEvent newGame = (NewGameEvent) e;
			switch (newGame.getStartupEventType()) {
			case SINGELPLAYER:{
				if (eventNotice instanceof IPlayer){
					client = new Client((IPlayer) eventNotice);
					view.setClient(client);					
				} else if (eventNotice instanceof IGame){
					// notify server
					OpenPatricianServer server = new OpenPatricianServer((IGame) eventNotice);
					server.startStandaloneGame(this);
				} else {
					throw new IllegalArgumentException("Unknown notice: "+eventNotice);
				}
				break;
			}
			default:
				throw new IllegalArgumentException("New game Startup type "+newGame.getStartupEventType()+" is not implemented");
			}
		}
	}
	/**
	 * Compute the size of the drawable rectangle with respect to the frame. Take into account the
	 * Frame header as well as bars that are added by the OS
	 */
	@Override
	protected void calcSizes() {
	    GraphicsConfiguration gc = getGraphicsConfiguration();
		Rectangle screenRect = gc.getBounds();
//System.out.println("Screen bounds: "+screenRect);
		// System.out.println("Screen size: " + screenRect);
	    Toolkit tk = Toolkit.getDefaultToolkit();
	    Insets desktopInsets = tk.getScreenInsets(gc);
//System.out.println("Desktop insets: "+desktopInsets);
	    
	    Insets frameInsets = getInsets();     // only works after a pack() call
//System.out.println("Frame insets "+frameInsets);
	    
	    Rectangle rect = new Rectangle(new Point(desktopInsets.left,frameInsets.top));

	    rect.width = screenRect.width - (desktopInsets.left + desktopInsets.right);

	    rect.height = screenRect.height - (desktopInsets.top + desktopInsets.bottom);
//System.out.println("Frame bounds: "+rect);	    
	    // System.out.println("pWidth: " + pWidth + "; pHeight: " + pHeight);
		if (rect.height<MainGameView.MINMIMAL_DISPLAY_HEIGHT){
			throw new RuntimeException("The frame in the display must have at least "+MainGameView.MINMIMAL_DISPLAY_HEIGHT+"px height");
		}
		setRectangle(rect);
	}


	@Override
	public IClient getClient() {
		return client;
	}

}
