package ch.sahits.game.graphic.display.gameplay;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.Event;
import ch.sahits.game.event.IEventListener;
import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.image.ImagesLoader;
import ch.sahits.game.rendering.RenderablePart;

/**
 * This is a dialog that renderes a wooden frame with an inlaid parchment at a given
 * position. Based on what the dialog represents the subclass may implement a {@link RenderablePart}.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Nov 18, 2011
 *
 */
public abstract class OpenPatricianGameDialog {
	/**
	 * Frame that is rendered
	 */
	private final BufferedImage img;
	/** Top left corner of the frame */
	private final Rectangle bounds;
	private final Insets inset;
	protected ImagesLoader loader;
	
	
	
	public OpenPatricianGameDialog(Point topLeft, ImagesLoader loader, double scale) {
		super();
		initiatePolygons();
		this.loader=loader;
		int top = (int) Math.ceil(scale*30);
		int side = (int) Math.ceil(scale*20);
		inset = new Insets(top, side, top, side);
		img = initBackgroundImage(loader,topLeft);
		bounds = new Rectangle(topLeft, new Dimension(img.getWidth(), img.getHeight()));
	}
	/**
	 * Instanciate the any polygon member variables
	 */
	protected void initiatePolygons() {
		// may be overridden
		
	}
	/**
	 * Initialize the background image that is stored as a reference. This method
	 * should be overridden by any subclass that contains static elements in the dialog.
	 * @param loader ImageLoader to retrieve images
	 * @return Image that will be stored as background
	 */
	protected BufferedImage initBackgroundImage(ImagesLoader loader,Point topLeft) {
		return loader.getImage("fringe");
	}

	public final Rectangle getBounds() {
		return bounds;
	}


	public void gameRender(Graphics gScr) {
		gScr.drawImage(img, bounds.x, bounds.y, null);
	}
	/**
	 * Retrieve the insets of the dialog border
	 * @return
	 */
	public Insets getInset() {
		return inset;
	}
	protected static class CloseAction implements Runnable{

		private final IEventListener dialog;
		
		
		public CloseAction(IEventListener dialog) {
			super();
			this.dialog = dialog;
		}


		@Override
		public void run() {
			new ViewChangeEvent(MainView.class).notify(EViewChangeEvent.CLOSE_DIALOG);
			Event.remove(dialog);
		}
		
	}

}
