package ch.sahits.game.graphic.display.gameplay;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

import ch.sahits.game.event.Event;
import ch.sahits.game.event.IEventListener;
import ch.sahits.game.rendering.AbstractRenderPart;
/**
 * This view represents the sub menu view
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Sep 30, 2011
 *
 */
public class SubMenu extends AbstractRenderPart implements IEventListener {

	public SubMenu(Rectangle rect) {
		super(rect);
		// TODO Auto-generated constructor stub
	}

	@Override
	public void gameRender(Graphics gScr) {
		Color oldColor = gScr.getColor();
//		gScr.setColor(Color.GREEN);
//		gScr.fillRect(rect.x, rect.y, rect.width, rect.height);
		gScr.setColor(Color.WHITE);
		final int x = 20+rect.x;
		final int y = rect.y+rect.height/2;
		gScr.drawString("SubMenu", x, y);
		gScr.setColor(oldColor);
		// TODO Auto-generated method stub

	}

	@Override
	public void gameUpdate(Event e, Object eventNotice) {
		// TODO Auto-generated method stub

	}

}
