package ch.sahits.game.graphic.display.util;

import java.awt.Point;

public class ClickablePolygon {

	private final NamedPolygon polygon;
	private final Runnable action;
	public ClickablePolygon(NamedPolygon polygon, Runnable action) {
		super();
		this.polygon = polygon;
		this.action = action;
	}
	/**
	 * check if the point is inside the polygon
	 * @param p Point
	 * @return true if p is inside the polygon
	 */
	public boolean isInside(Point p){
		return polygon.contains(p);
	}
	/**
	 * Execute the action associated with the polygon
	 */
	public void execute(){
		action.run();
	}
	public NamedPolygon getPolygon(){
		return polygon;
	}
}
