package ch.sahits.game.graphic.display.util;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

/**
 * This class represents an ordered list of poligons. With each polygon is an action
 * associated that is executed if clicked inside the polygon.  
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Nov 23, 2011
 *
 */
public class ClickablePolygons {

	private List<ClickablePolygon> polygons = new ArrayList<ClickablePolygon>();
	private Rectangle area = null;
	/**
	 * Add a new polygon to the list
	 * @param polygon
	 * @param action
	 */
	public void add(NamedPolygon polygon, Runnable action){
		polygons.add(new ClickablePolygon(polygon, action));
		updateArea(polygon);
	}
	private void updateArea(Polygon polygon) {
		Rectangle boundingBox = polygon.getBounds();
		if (area==null){
			area = boundingBox;
		} else {
			if (area.x>boundingBox.x){
				area.x=boundingBox.x;
			}
			if (area.y>boundingBox.y){
				area.y=boundingBox.y;
			}
			if (area.x+area.width<boundingBox.x+boundingBox.width){
				area.width=boundingBox.x+boundingBox.width-area.x;
			}
			if (area.y+area.height<boundingBox.y+boundingBox.height){
				area.height=boundingBox.y+boundingBox.height-area.y;
			}
			
		}
		
	}
	/**
	 * Find the polygon that contains the point and if such a polygon
	 * exists execute its action
	 * @param p
	 */
	public void testAndExecute(Point p){
		if (area==null || area.contains(p)){
			ClickablePolygon polygon = findPolygon(p);
			if (polygon!=null){
				polygon.execute();
			}
		}
	}
	/**
	 * Find the first polygon that has the point inside it.
	 * @param p
	 * @return
	 */
	private ClickablePolygon findPolygon(Point p){
		for (ClickablePolygon polygon : polygons) {
			if (polygon.isInside(p)){
System.out.println("Found polygon: "+polygon.getPolygon().getName());				
				return polygon;
			}
		}
		return null;
	}
}
