package ch.sahits.game.graphic.display.util;

import java.awt.Polygon;
/**
 * Version of the Ploygon that is identified by a name.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Mar 1, 2011
 *
 */
public class NamedPolygon extends Polygon {
	private final String name;

	public NamedPolygon(String name) {
		super();
		this.name=name;
	}

	public NamedPolygon(int[] xpoints, int[] ypoints, int npoints,String name) {
		super(xpoints, ypoints, npoints);
		this.name=name;
	}

	public String getName() {
		return name;
	}
	
	public String toString(){
		StringBuilder sb = new StringBuilder();
		sb.append("[");
		for (int i=0;i<npoints;i++){
			sb.append(xpoints[i]).append("x").append(ypoints[i]);
			if (i<npoints-1){
				sb.append(",");
			}
		}
		sb.append("]");
		return sb.toString();
	}
}
