package ch.sahits.game.graphic.display.util;

import java.awt.Point;

/**
 * A perspective image is a rectangular that is distored and becomes a quadrangle.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Feb 26, 2011
 *
 */
public final class PerspectiveImage {

	private final Point topLef;
	private final Point topRight;
	private final Point bottomLeft;
	private final Point bottomRight;
	
	public PerspectiveImage(Point topLef, Point topRight, Point bottomLeft,
			Point bottomRight) {
		super();
		this.topLef = topLef;
		this.topRight = topRight;
		this.bottomLeft = bottomLeft;
		this.bottomRight = bottomRight;
	}
	public Point getTopLef() {
		return topLef;
	}
	public Point getTopRight() {
		return topRight;
	}
	public Point getBottomLeft() {
		return bottomLeft;
	}
	public Point getBottomRight() {
		return bottomRight;
	}
	
}
