package ch.sahits.game.graphic.display.util;

import java.util.Arrays;

/**
 * A polynom is a figure consisting of n {@link Edge}s. The last Point of the last edge is
 * identical with the first point of the first edge.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Feb 27, 2011
 *
 */
final class Polygon {

	private String name;
	private final Edge[] edges;
	public Polygon(String name, Edge[] edges) {
		this(edges);
		this.name = name;
	}
	public Polygon(Edge[] edges) {
		super();
		this.edges = edges;
	}
	public Edge[] getEdges() {
		return edges;
	}
	public String getName() {
		return name;
	}
	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("Polygon [edges=");
		for (Edge edge : getEdges()) {
			sb.append(edge.toString());
		}
		sb.append("]");
		return sb.toString();
	}
	
}
