package ch.sahits.game.graphic.layout;

import java.awt.Font;

/**
 * Component that can hold a single value that can be edited.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Jun 6, 2011
 *
 * @param <T> type of the value
 */
public abstract class AbstractEditableSahitsComponent<T> extends AbstractSahitsComponent{
	
	private T value=null;
	private Font font;

	public T getValue() {
		return value;
	}

	public void setValue(T value) {
		this.value = value;
	}
	
	@Override
	public Font getFont() {
		return font;
	}

	public void setFont(Font font) {
		this.font = font;
	}


}
