package ch.sahits.game.graphic.layout;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.ArrayList;

import ch.sahits.game.graphic.display.IUpdatableComponent;

public abstract class AbstractMultiselectableComponent<T> extends AbstractSahitsComponent implements IUpdatableComponent{
	
	private Font font;
	protected ArrayList<T> selectables = new ArrayList<T>();
	private int selectedIndex = -1;
	private boolean update = true;

	public void add(T item){
		selectables.add(item);
		if (selectedIndex==-1){
			selectedIndex=0;
		}
	}
	public T getSelected(){
		if (selectedIndex>=0 && selectedIndex<selectables.size()){
			return selectables.get(selectedIndex);
		} else {
			return null;
		}
	}
	
	public void incSelection(){
		if (selectedIndex<selectables.size()-1){
			setSelected(selectedIndex+1);
		}
	}
	public void decSelection(){
		if (!selectables.isEmpty() && selectedIndex>0){
			setSelected(selectedIndex-1);
		}
	}
	
	public final int getSelectedIndex(){
		return selectedIndex;
	}
	public final int getItemCount(){
		return selectables.size();
	}
	public T getItem(int index){
		return selectables.get(index);
	}
	public void setSelected(int index){
		if (index>=0 && index<selectables.size()){
			selectedIndex=index;
		} else {
			throw new IllegalArgumentException("Index out of selectable range");
		}
	}
	

	@Override
	public Font getFont() {
		return font;
	}

	@Override
	public void setFont(Font f) {
		font=f;
	}
	@Override
	public void gameRender(Graphics gScr) {
		if (update){
			paint(gScr);
			update=false;
		}
	}
	@Override
	public void gameUpdate() {
		update=true;
	}
	@Override
	public void testKeyPress(KeyEvent e) {
		// no key input handled
	}

}
