package ch.sahits.game.graphic.layout;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;

import ch.sahits.game.graphic.display.IUpdatableComponent;
import ch.sahits.game.graphic.display.IUpdatableComponent;

public abstract class AbstractSelectableComponent extends AbstractSahitsComponent implements IUpdatableComponent{

	private Font font=null;
	private boolean selected=false;
	private final FontMetrics metrics;
	
	public AbstractSelectableComponent(FontMetrics metrics) {
		super();
		this.metrics = metrics;
	}
	protected FontMetrics getFontMetrics(){
		return metrics;
	}

	@Override
	public Font getFont() {
		return font;
	}

	@Override
	public void setFont(Font f) {
		font=f;
	}

	public boolean isSelected() {
		return selected;
	}

	public void setSelected(boolean selected) {
		this.selected = selected;
	}
	@Override
	public void gameRender(Graphics gScr) {
		paint(gScr);
	}
	@Override
	public void gameUpdate() {
		// no update needed
	}
	/**
	 * Key events are not handled
	 */
	@Override
	public void testKeyPress(KeyEvent e) {
	}
	

}
