package ch.sahits.game.graphic.layout;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

import ch.sahits.game.graphic.display.IUpdatableComponent;

public class Button extends AbstractSahitsComponent implements
		IUpdatableComponent {
	
	private Font font;
	private final FontMetrics metric;
	private String text = null;
	private int V_BORDER = 10;
	private int H_BORDER = 5;
	private Runnable action=null;
	public Button(FontMetrics fm){
		metric = fm;
	}

	@Override
	public void gameRender(Graphics gScr) {
		// nothing to be done
	}

	@Override
	public void gameUpdate() {
		// nothing to be done

	}

	@Override
	public void paint(Graphics g) {
		String s = text;
		if (s==null){
			s="";
		}
		Rectangle bounds = getBounds();
		/*
	    BufferedImage img = painter.createButton(g,s,bounds);
System.out.println("Button bounds: "+bounds);	    

System.out.println("Button dim: "+img.getWidth()+"x"+img.getHeight());	    
		g.drawImage(img, bounds.x, bounds.y, null);*/
	    painter.paintButton(g, bounds);

		try {
			Graphics2D g2d = (Graphics2D) g;
			GlyphVector gv = painter.createGlyphVector(g2d,s, font.getSize());
			int descent = metric.getDescent();
			g2d.drawGlyphVector(gv, bounds.x+V_BORDER, bounds.y+bounds.height-descent-H_BORDER);
		} catch (FontFormatException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	@Override
	public Dimension getPreferredSize() {
		String s = text;
		if (s==null){
			s="";
		}
		Rectangle2D view = createVisualBounds(s);
		if (view == null){
			return new Dimension();
		}
		Dimension dim = new Dimension();
		Insets insets = getInsets();
		dim.height=insets.top+insets.bottom+metric.getAscent()+metric.getDescent()+2*H_BORDER;
		dim.width=insets.left+insets.right+(int)Math.rint(view.getWidth())+2*V_BORDER;
		return dim;
	}

	@Override
	public Font getFont() {
		return font;
	}

	@Override
	public void setFont(Font f) {
		font = f;
	}

	@Override
	public void testClick(Point p) {
		if (getBounds().contains(p) && action != null){
			action.run();
		}

	}

	@Override
	public void testKeyPress(KeyEvent e) {
		// no key events

	}

//	@Override
//	public void testMouseReleased(MouseEvent e) {
//		// no mouse released events
//
//	}
//
//	@Override
//	public void testMouseDrag(MouseEvent e) {
//		// no mouse dragged events
//
//	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}
	public void setAction(Runnable run){
		action=run;
	}

}
