package ch.sahits.game.graphic.layout;
/**
 * Enumeration of the positions an element can take inside a
 * cell in a MaximalGridLayout.
 * 
 * @see MaximalGridLayoutConstraints
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on May 27, 2011
 *
 */
public enum ECellPosition {
	TOP_LEFT(0f,0f),
	TOP(0.5f,0f),
	TOP_RIGHT(1f,0f),
	LEFT(0f,0.5f),
	CENTER(0.5f,0.5f),
	RIGHT(1f,0.5f),
	BOTTOM_LEFT(0f,1f),
	BOTTOM(0.5f,1f),
	BOTTOM_RIGHT(1f,1f);
	private final float positionX;
	private final float positionY;
	/**
	 * Constructor converts the enumeration values into the values needed
	 * by the methods getLayoutAlignmentX and getLayoutAlignmentY of
	 * LayoutManager2
	 * @param posX
	 * @param posY
	 */
	private ECellPosition(float posX,float posY){
		positionX=posX;
		positionY=posY;
	}
	float getPositionX() {
		return positionX;
	}
	float getPositionY() {
		return positionY;
	}
	
}
