package ch.sahits.game.graphic.layout;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.io.IOException;


public class Label extends AbstractSahitsComponent implements ISahitsLabel {
	
	private String text;
	private Font font;
	private final FontMetrics metric;
	public Label(FontMetrics fm) {
		super();
		metric=fm;
	}

	@Override
	public void paint(Graphics g) {
		Rectangle bounds = getBounds();
		try {
			String s = text;
			if (s==null){
				s="";
			}
			Graphics2D g2d = (Graphics2D) g;
			GlyphVector gv = painter.createGlyphVector(g2d,s, font.getSize());
			int descent = metric.getDescent();
			g2d.drawGlyphVector(gv, bounds.x, bounds.y+bounds.height-descent);
		} catch (FontFormatException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}


	@Override
	public Dimension getPreferredSize() {
		String s = text;
		if (s==null){
			s="";
		}
		Rectangle2D view = createVisualBounds(s);
		if (view == null){
			return new Dimension();
		}
		Dimension dim = new Dimension();
		Insets insets = getInsets();
		dim.height=insets.top+insets.bottom+metric.getAscent()+metric.getDescent();
		dim.width=insets.left+insets.right+(int)Math.rint(view.getWidth());
		return dim;
	}
	/**
	 * Retrieve the font
	 * @return
	 */
	@Override
	public Font getFont() {
		return font;
	}

	@Override
	public void setText(String text) {
		this.text=text;
	}

	@Override
	public void setFont(Font f) {
		font = f;
	}
}
