package ch.sahits.game.graphic.layout;

import ch.sahits.game.graphic.display.ISahitsLayoutConstraint;

/**
 * Container to hold the constraints.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on May 27, 2011
 *
 */
public final class MaximalGridLayoutConstraints implements ISahitsLayoutConstraint{
	private final ECellPosition anchor;
	/**
	 * Default constraint with centered positioning
	 */
	MaximalGridLayoutConstraints(){
		this(null);
	}
	/**
	 * Layout with custom positioning
	 * @param anchor
	 */
	public MaximalGridLayoutConstraints(ECellPosition anchor) {
		super();
		if (anchor==null){
			this.anchor=ECellPosition.CENTER;
		} else {
			this.anchor = anchor;
		}
	}

	public ECellPosition getAnchor() {
		return anchor;
	}
	
}
