package ch.sahits.game.graphic.layout;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Properties;

import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JPanel;

import ch.sahits.game.openpatrician.util.PropertyLoader;
/**
 * Implementable selecteable Radio button. This component is a single selectable.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Jun 9, 2011
 *
 */
public class RadioButton extends AbstractSelectableComponent {
	
	private final SelectableGroup group;
	private String text;

	

	public RadioButton(SelectableGroup group, JPanel panel, Font f) {
		super(panel.getFontMetrics(f));
		setFont(f);
		this.group = group;
	}
	public RadioButton(SelectableGroup group, FontMetrics metric, Font f){
		super(metric);
		setFont(f);
		this.group = group;
	}

	@Override
	public void paint(Graphics g) {
		BufferedImage checkBoxImg = painter.createRadioButtonImage();
		// get an image with the drawn texts on them
		Rectangle rect = getBounds();
		BufferedImage textAugmentation = painter.createTextOnSlab4ToggleButton(text, getFont(), checkBoxImg.getWidth(), (int)Math.rint(rect.getWidth()),  (int)Math.rint(rect.getHeight()));
		BufferedImage merge = new BufferedImage(textAugmentation.getWidth(), textAugmentation.getHeight(), BufferedImage.TYPE_INT_ARGB);
		Graphics drawG = merge.getGraphics();
		drawG.drawImage(checkBoxImg, 0, 0, null);
		drawG.drawImage(textAugmentation, 0, 0, null);
		
	    Color oldColor = drawG.getColor();
	    drawG.setColor(Color.WHITE);	    

		Properties props = PropertyLoader.loadProperties("DrawHelperMessages");
	    if (isSelected())
	    {
	      // Write yes in language
	    	painter.drawString((Graphics2D) drawG, props.getProperty("yes"), 16, 30, 42);

	    } else {
	  	  // Write no in language
	    	painter.drawString((Graphics2D) drawG, props.getProperty("no"), 16, 30, 42);
	    }
		g.drawImage(merge, rect.x, rect.y, null);	

		drawG.setColor(oldColor);
	}

	@Override
	public Dimension getPreferredSize() {
		String s =text;
		int length = getFontMetrics().charsWidth(s.toCharArray(), 0, s.length());
		BufferedImage checkBoxImg = painter.createRadioButtonImage();
		length = length-28; // 28 pixel on the checkBoxImg
		if (length>0){
			length = checkBoxImg.getWidth()+length;
		} else {
			length = checkBoxImg.getWidth();
		}
		return new Dimension(length, checkBoxImg.getHeight());
	}
	public void setText(String text) {
		this.text=text;
	}
	/**
	 * Update the selected state
	 * @param selected
	 */
	private void updateSelected(boolean selected) {
		if (selected){
			setSelected(selected);
			group.unselectOthers(this);
		}
	}

	public void testClick(MouseEvent e) {
		if (!isSelected() && getBounds().contains(e.getPoint())){			
			updateSelected(true);
		}
	}
	@Override
	public void testClick(Point p) {
		if (!isSelected() && getBounds().contains(p)){			
			updateSelected(true);
		}
	}
//	@Override
//	public void testMouseReleased(MouseEvent e) {
//		// not handled
//	}
//	@Override
//	public void testMouseDrag(MouseEvent e) {
//		// not handled
//	}

	@Override
	public String toString() {
		return "RadioButton [" + text + " "+isSelected()+"]";
	}

	

}
