package ch.sahits.game.graphic.layout;

import java.awt.Dimension;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

import ch.sahits.game.graphic.display.IUpdatableComponent;
import ch.sahits.game.graphic.display.IUpdatableComponent;

public class TextInput extends AbstractEditableSahitsComponent<String> implements IUpdatableComponent{
	// TODO add input change action
	
	private int size=1;
	private int updateCouter=0;
	private boolean hasFocus=false;
	private boolean drawCarret = true;
	private final FontMetrics metric;
	
	private final int TEXT_INSET = 5;
	
	public TextInput(FontMetrics fm){
		setValue("");
		metric=fm;
	}
	

	public void setSize(int size) {
		this.size = size;
	}

	@Override
	public void paint(Graphics g) {
		Rectangle rect = getBounds();
		BufferedImage img = painter.createScaledPlank(rect.width, rect.height);
		g.drawImage(img, rect.x, rect.y, rect.width, rect.height, null);
		String s = getValue();
		if (drawCarret && hasFocus){
			s += "|";
		}
		if (s!=null && s.length()>0){
			try {
				GlyphVector gv = painter.createGlyphVector(s, getFont().getSize());
				Insets insets = getInsets();
				int x = rect.x+insets.left;
				int y = rect.y+insets.top+rect.height-TEXT_INSET; 
				int descent = metric.getDescent();
				((Graphics2D)g).drawGlyphVector(gv, x, y-descent); // (x,y) denotes the baseline of the leftmost character
			} catch (FontFormatException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	@Override
	public Dimension getPreferredSize() {
		final String hString = "Tg";
		final String wString = "m";
		Dimension dim = new Dimension();
		Rectangle2D rect = createVisualBounds(hString);
		Insets insets = getInsets();
		if (rect!=null){
			dim.height=metric.getAscent()+metric.getDescent()+insets.top+insets.bottom+2*TEXT_INSET;
		}
		rect = createVisualBounds(wString);
		if (rect!=null){
			dim.width=size*(int) Math.rint(rect.getWidth())+insets.right+insets.left;
		}
		return dim;
	}

	@Override
	public void gameRender(Graphics gScr) {
		paint(gScr);
	}

	@Override
	public void gameUpdate() {
		updateCouter++;
		updateCouter %= 30;
		if (updateCouter==0){
			drawCarret = !drawCarret;
		}
	}

	@Override
	public void testClick(Point p) {
		Rectangle rect = getBounds();
		if (rect.contains(p)){
			hasFocus=true;
			drawCarret=true;
		} else {
			hasFocus=false;
			drawCarret=false;
		}
		
	}


	@Override
	public void testKeyPress(KeyEvent e) { // is there a better way?
		if (hasFocus){ 
			// TODO add delete
			String v = getValue();
			int code = e.getKeyCode();
			if (code==KeyEvent.VK_BACK_SPACE){
				if (v.length()>0){
					updateValue(v.substring(0, v.length()-1));
				}
			} else if (code==KeyEvent.VK_LEFT){
				// TODO update position
			} else if (code==KeyEvent.VK_RIGHT){
				// TODO update position
			} else {
				char ch = e.getKeyChar();
				if (ch != KeyEvent.CHAR_UNDEFINED){
					updateValue(v+ch);
				}
			}
		}
	}

	private void updateValue(String s) {
		setValue(s);
	}


//	@Override
//	public void testMouseReleased(MouseEvent e) {
//		// not handled
//	}
//	@Override
//	public void testMouseDrag(MouseEvent e) {
//		// not handled
//	}

}
