package ch.sahits.game;

import java.util.Properties;

import javax.swing.JFrame;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

import ch.sahits.game.graphic.display.OpenPatricianFrame;
import ch.sahits.game.openpatrician.util.PropertyLoader;

/**
 * Main class for starting the OpenPatrician game.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 16, 2011
 *
 */
public class OpenPatrician {
	
	private static Logger logger = Logger.getLogger(OpenPatrician.class);
	
//	private final static String START_CLIENT = "-c";
//	private final static String START_SERVER = "-s";
//	private final static String HELP = "?";
	
	private volatile static boolean startedServer = false;
	
	private final static Object lock = new Object();

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		Properties properties = PropertyLoader.loadProperties("log4j.properties");
		PropertyConfigurator.configure(properties);
		logEnvironment();
		boolean startServer = false;
//		if (args.length>0){
//			for (int i = 0; i < args.length; i++) {
//				if (args[i].equals(START_CLIENT)){
//					startServer=false;
//				} else if (args[i].equals(START_SERVER)){
//					startServer=true;
//				} else if (args[i].equals(HELP)){
//					printUsage();
//					System.exit(0);
//				}
//			}
//		}
		if (startServer){
			logger.error("Multiplayer game is not yet implemented, sorry.");
			System.exit(0);
		} else {
			OpenPatricianFrame opf = new OpenPatricianFrame();
			opf.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			opf.setVisible(true);
		}

	}

	private static void logEnvironment() {
		Properties sysprops = System.getProperties();
		StringBuilder sb = new StringBuilder();
		sb.append("Java VM version").append(": ").append(sysprops.get("java.vm.version"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("Java runtime version").append(": ").append(sysprops.get("java.runtime.version"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("Java VM vendor").append(": ").append(sysprops.get("java.vm.vendor"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("Java VM name").append(": ").append(sysprops.get("java.vm.name"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("Java version").append(": ").append(sysprops.get("java.version"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("Java specification version").append(": ").append(sysprops.get("java.specification.version"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("Graphics environment").append(": ").append(sysprops.get("java.awt.graphicsenv"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("User country").append(": ").append(sysprops.get("user.country"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("User language").append(": ").append(sysprops.get("user.language"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("OS architecture").append(": ").append(sysprops.get("os.arch"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("OS name").append(": ").append(sysprops.get("os.name"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("OS version").append(": ").append(sysprops.get("os.version"));
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}
		sb = new StringBuilder();
		sb.append("Start command").append(": ").append(sysprops.get("sun.java.command")); // ?? is this generally availalbe
		if (logger.isInfoEnabled()) {
			logger.info(sb.toString());
		}

	}

	/**
	 * Create the server instance for a standalone game. If the server is already started no
	 * second server will be started.
	 * @param userGui Thread/Runnable that handels the users GUI rendering
	 */
	public static void createStandaloneServer(OpenPatricianFrame userGui){
		synchronized (lock) {
			if (startedServer) return; // only start the server once
		}
		// PRE: The server is not yet started
		// TODO: create server with AI players and one human player
	}
	
	// TODO add method connectToServer

}
