package ch.sahits.game.graphic.display;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;

/**
 * The ISahitsComponent is a renderable form element whithin a ISahitsContainer.
 * It is the equivalent to a JComponent in swing.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Jun 5, 2011
 *
 */
public interface ISahitsComponent {
	/**
	 * Draw the component with the appropriate graphic context.
	 * Before calling this method make sure it is appropriately initialized.
	 * @param g
	 */
	public void paint(Graphics g);
	/**
	 * Define the measurements of the component
	 * @param x position along the x axis
	 * @param y position along the y axis
	 * @param width of the component
	 * @param height of the component
	 */
	public void setBounds(int x, int y, int width, int height);
	/**
	 * Retrieve the preferred size of the component.
	 * @return
	 */
	public Dimension getPreferredSize();
	/**
	 * Define the insets of the component
	 * @param top
	 * @param right
	 * @param bottom
	 * @param left
	 */
	public void setInsets(int top, int right, int bottom, int left);
	/**
	 * Retrieve the font
	 * @return
	 */
	public Font getFont();
	/**
	 * Set the font
	 * @param f
	 */
	public void setFont(Font f);
	/**
	 * Retrieve the bounds of the component
	 * @return
	 */
	public abstract Rectangle getBounds();
}
