package ch.sahits.game.graphic.display;

import java.awt.Insets;
import java.awt.Rectangle;

/**
 * This container component is used to hold ISahistsComponents that are rendered within this container.
 * The base concept is the same as with Java/Swing container/component however with much less overhead.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Jun 5, 2011
 *
 */
public interface ISahitsContainer {
	/**
	 * Add a component to the container with a specific constraint
	 * @param comp {@link ISahitsComponent}
	 * @param constraint {@link ISahitsLayoutConstraint}
	 */
	public void add(ISahitsComponent comp, ISahitsLayoutConstraint constraint);
	/**
	 * Retrieve a component from internal storage at position i.
	 * This method does not guarantee any order.
	 * @param i position in the internal storage.
	 * @return
	 */
	public ISahitsComponent get(int i);
	/**
	 * Retrieve the total number of components contained in this container
	 * @return number of contained {@link ISahitsComponent}s
	 */
	public int getComponentCount();
	/**
	 * Retrieve the insets of the container
	 * @return
	 */
	public Insets getInsets();
	/**
	 * Retrieve the bounds of the container
	 * @return
	 */
	public Rectangle getBounds();
	/**
	 * Retrieve the actual height of the container
	 * @return height in pixels
	 */
	public int getHeight();
	/**
	 * Retrieve the actual width of the container
	 * @return width in pixels
	 */
	public int getWidth();
}
