package ch.sahits.game.graphic.display;
/**
 * This interfaces defines the layout manager that is to be used for
 * placing the {@link ISahitsComponent}s in a {@link ISahitsComponent}.
 * The workings are similar than with LayoutManager2. The components are
 * added from the {@link ISahitsContainer}s add method and layouted from
 * its {@link ISahitsComponent#paint(java.awt.Graphics)} method.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Jun 5, 2011
 *
 */
public interface ISahitsLayoutManager {
	/**
	 * Add a component with a constraint.
	 * @param comp
	 * @param constraint
	 */
	public void addLayoutComponent(ISahitsComponent comp, ISahitsLayoutConstraint constraint);
	/**
	 * Compute the layout of the all the children in the parent container.
	 * @param parent
	 */
	public void layoutContainer(ISahitsContainer parent);
}
