package ch.sahits.game.graphic.display;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
/**
 * Interface defines a updatable component.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Jun 6, 2011
 *
 */
public interface IUpdatableComponent {
	/**
	 * Test if there was a mouse click on the component
	 * @param e
	 */
	public void testClick(Point p);
	
	/**
	 * Check the updatable components if the key press was in one of them
	 * @param e
	 */
	public void testKeyPress(KeyEvent e);
//	/**
//	 * Check the updatable components if the mouse was released
//	 * @param e
//	 */
//	public void testMouseReleased(MouseEvent e);
//	/**
//	 * check the updateable component if the mouse was dragged
//	 * @param e
//	 */
//	public void testMouseDrag(MouseEvent e);

	/**
	 * Force the panel to render itself.
	 * @param gScr Graphics used for the rendering
	 */
	public void gameRender(Graphics gScr);
	/**
	 * Force the panel to update its state.
	 */
	public void gameUpdate();

}
