package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.graphic.display.model.CityPlayerProxy;

/**
 * This interfaces defines methods that are accessed by the Transfer actions
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 11, 2011
 *
 */
interface ITransferable {

	/**
	 * Retrieve the amount that is to be transferred. This method does
	 * not consider how much is available.
	 * @param maxMount
	 * @return
	 */
	public int getAmount(int maxMount);
	/**
	 * Retrieve the amount size that is to be transfer in one chunk.
	 * @return
	 */
	public ETransferAmount getMovableAmount();
	/**
	 * Retrieve the proxy object to access the city and the player
	 * @return
	 */
	public CityPlayerProxy getCityPlayerProxy();
	/**
	 * Retrieve the dialog type of this transfer
	 * @return transfer dialog type
	 */
	public ETransferDialogType getDialogType();
	/**
	 * set the transfer dialog type
	 * @param type of the transfer dialog
	 */
	public void setDialogType(ETransferDialogType type);

}
